% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-gnd.r
\name{util_makeZhangParam}
\alias{util_makeZhangParam}
\title{Parameters for progressive morphological filter}
\usage{
util_makeZhangParam(b = 2, dh0 = 0.5, dhmax = 3, s = 1,
  max_ws = 20, exp = FALSE)
}
\arguments{
\item{b}{numeric. This is the parameter \eqn{b} in Zhang et al. (2003) (eq. 4 and 5).}

\item{dh0}{numeric. This is \eqn{dh_0} in Zhang et al. (2003) (eq. 7).}

\item{dhmax}{numeric. This is \eqn{dh_{max}} in Zhang et al. (2003) (eq. 7).}

\item{s}{numeric. This is \eqn{s} in Zhang et al. (2003) (eq. 7).}

\item{max_ws}{numeric. Maximum window size to be used in filtering ground returns. This limits
the number of windows created.}

\item{exp}{logical. The window size can be increased linearly or exponentially (eq. 4 or 5).}
}
\value{
A list with two components: the windows size sequence and the threshold sequence.
}
\description{
The function \link{lasground} with the progressive morphological filter allows for any
sequence of parameters. This function enables computation of the sequences using equations (4),
 (5) and (7) from Zhang et al. (see reference and details).
}
\details{
In the original paper the windows size sequence is given by eq. 4 or 5:\cr\cr

\eqn{w_k = 2kb + 1} \cr\cr
or\cr\cr
\eqn{w_k = 2b^k + 1}\cr\cr

In the original paper the threshold sequence is given by eq. 7:\cr\cr
\eqn{th_k = s*(w_k - w_{k-1})*c + th_0}\cr\cr
Because the function \link{lasground} applies the morphological operation at the point
cloud level the parameter \eqn{c} is set to 1 and cannot be modified.
}
\examples{
p = util_makeZhangParam()
}
\references{
Zhang, K., Chen, S. C., Whitman, D., Shyu, M. L., Yan, J., & Zhang, C. (2003). A progressive
morphological filter for removing nonground measurements from airborne LIDAR data. IEEE
Transactions on Geoscience and Remote Sensing, 41(4 PART I), 872–882. http:#doi.org/10.1109/TGRS.2003.810682.
}
