% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_intraday.R
\name{plot_i}
\alias{plot_i}
\alias{plot_i_steps}
\alias{plot_i_floors}
\alias{plot_i_cal}
\alias{plot_i_active_min}
\alias{plot_i_hr}
\alias{plot_i_hr_datetime}
\alias{plot_i_weight}
\title{Line graph for a single continuous variable.}
\usage{
plot_i(person, measure_var, avg_to_get_typical_day = TRUE)

plot_i_steps(person, avg_to_get_typical_day = TRUE)

plot_i_floors(person, avg_to_get_typical_day = TRUE)

plot_i_cal(person, avg_to_get_typical_day = TRUE)

plot_i_active_min(person, avg_to_get_typical_day = TRUE)

plot_i_hr(person, avg_to_get_typical_day = TRUE)

plot_i_hr_datetime(person)

plot_i_weight(person, avg_to_get_typical_day = TRUE, unit = "lb")
}
\arguments{
\item{person}{An instance of the Person class}

\item{measure_var}{character vector denoting the variables of interest.
Options are one or more of: "steps", "floors", "distance", 
"caloriesBurned","bpm" (heart rate), "weight".}

\item{avg_to_get_typical_day}{Logical variable "daily" for an aggregate of 
the variable over the course of a day, or "intraday" for the variable at 
every interval over the range.  Default is TRUE.}

\item{unit}{Unit of measurement for plot_i_weight().  Default is "lb", but 
"kb" can also be specified}
}
\value{
ggplot object
}
\description{
Provides a "quick-and-dirty" approach to plotting a line graph 
    for a single continuous variable using defaults for axis and title 
    labels.  Users can specify if they want to look at an aggregate of a 
    variable over the course of a day (avg_to_get_typical_day = TRUE) or look
    at that variable at every interval (i.e. every 15 minutes for the entire 
    date range).
}
\section{Functions}{
\itemize{
\item \code{plot_i_steps}: Line graph for steps taken per 15 minute interval over 
date-time.

\item \code{plot_i_floors}: Line graph for floors gone up per 15 minute interval over 
date-time.

\item \code{plot_i_cal}: Line graph for calories burned per 15 minute interval over 
date-time.

\item \code{plot_i_active_min}: Line graph for active minutes per 15 minute interval over 
date-time.

\item \code{plot_i_hr}: Line graph for heart rate per 5 minute interval across a
typical day or over date-time.

\item \code{plot_i_hr_datetime}: Line graph for heart rate per 5 minute interval across a
typical day.

\item \code{plot_i_weight}: Line graph for weight over time.
}}

\examples{
data(EX)
plot_i(EX, "steps")
plot_i(EX, "distance", FALSE)
}
\seealso{
\code{\link{get_hr_zones}}
}
