% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_posterior.R
\name{getPosteriorFit}
\alias{getPosteriorFit}
\title{Compute posterior fit for linear models for rhythmicity}
\usage{
getPosteriorFit(
  fit,
  covMethod = c("data-driven", "canonical", "both"),
  getSigResArgs = list(),
  npc = fit$nKnots,
  covEdArgs = list(),
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{fit}{A \code{limorhyde2} object.}

\item{covMethod}{String indicating the type(s) of covariance matrices to use
for the mash fit.}

\item{getSigResArgs}{List of arguments passed to
\code{\link[mashr:get_significant_results]{mashr::get_significant_results()}}. Only used if \code{covMethod} is
'data-driven' or 'both'.}

\item{npc}{Number of principal components passed to \code{\link[mashr:cov_pca]{mashr::cov_pca()}}. Only
used if \code{covMethod} is 'data-driven' or 'both'.}

\item{covEdArgs}{List of arguments passed to \code{\link[mashr:cov_ed]{mashr::cov_ed()}}. Only used if
\code{covMethod} is 'data-driven' or 'both'.}

\item{overwrite}{Logical for whether to recompute the mash fit if it already
exists.}

\item{...}{Additional arguments passed to \code{\link[mashr:mash]{mashr::mash()}}.}
}
\value{
A \code{limorhyde2} object containing everything in \code{fit} with added or
updated elements:
\itemize{
\item \code{mashData}: list of \code{mash} data objects
\item \code{mashFits}: list of \code{mash} fit objects
\item \code{mashCoefficients}: Matrix of posterior mean coefficients, with rows
corresponding to features and columns to model terms.
\item \code{mashIdx}: Vector indicating which model terms were included in the mash
fit.
}
}
\description{
This is the second step in an analysis using \code{limorhyde2}, the first is to
fit linear models using \code{\link[=getModelFit]{getModelFit()}}. This function obtains posterior
estimates of coefficients using multivariate adaptive shrinkage (mash), which
learns patterns in the data and accounts for noise in the original fits. The
defaults for arguments should work well in most cases, so only change them if
you know what you're doing.
}
\examples{
library('data.table')

# rhythmicity in one condition
y = GSE54650$y
metadata = GSE54650$metadata

fit = getModelFit(y, metadata)
fit = getPosteriorFit(fit)
rhyStats = getRhythmStats(fit, features = c('13170', '13869'))

# rhythmicity and differential rhythmicity in multiple conditions
y = GSE34018$y
metadata = GSE34018$metadata

fit = getModelFit(y, metadata, nKnots = 3L, condColname = 'cond')
fit = getPosteriorFit(fit)
rhyStats = getRhythmStats(fit, features = c('13170', '12686'))
diffRhyStats = getDiffRhythmStats(fit, rhyStats)
}
\seealso{
\code{\link[=getModelFit]{getModelFit()}}, \code{\link[=getRhythmStats]{getRhythmStats()}}, \code{\link[=getExpectedMeas]{getExpectedMeas()}}
}
