% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{kernCompute}
\alias{kernCompute}
\title{Kernel Matrix for \code{"lineqGP"} Models.}
\usage{
kernCompute(x1, x2 = NULL, type, par, d = 1L)
}
\arguments{
\item{x1}{a vector with the first input locations.}

\item{x2}{a vector with the second input locations.}

\item{type}{a character string corresponding to the type of the kernel.
Options: "gaussian", "matern32", "matern52", "exponential".}

\item{par}{the values of the kernel parameters (variance, lengthscale).}

\item{d}{a number corresponding to the dimension of the input space.}
}
\value{
Kernel matrix \eqn{K(x_1,x_2)}{K(x1,x2)}
(or \eqn{K(x_1,x_1)}{K(x1,x1)} if \eqn{x_2}{x2} is not defined).
}
\description{
Compute the kernel matrix for \code{"lineqGP"} models.
attr: "gradient".
}
\examples{
x <- seq(0, 1, 0.01)
K <- kernCompute(x, type = "gaussian", par =  c(1, 0.1))
image(K, main = "covariance matrix")

}
\author{
A. F. Lopez-Lopera.
}
