% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{standardize.lspace}
\alias{standardize.lspace}
\title{Standardize a Latent Semantic Space}
\usage{
standardize.lspace(infile, name, sep = " ", digits = 9,
  dir = getOption("lingmatch.lspace.dir"), outdir = dir, remove = "",
  term_check = "^[a-zA-Z]+$|^['a-zA-Z][a-zA-Z.'\\\\/-]*[a-zA-Z.]$",
  verbose = FALSE)
}
\arguments{
\item{infile}{Name of the .rda or plain-text file relative to \code{dir}, \cr
e.g., "default.rda" or "glove/glove.6B.300d.txt".}

\item{name}{Base name of the reformatted file and term file; e.g., "glove" would result in
\code{glove.dat} and \code{glove_terms.txt} in \code{outdir}.}

\item{sep}{Delimiting character between values in each line, e.g., \code{" "} or \code{"\\t"}.
Only applies to plain-text files.}

\item{digits}{Number of digits to round values to; default is 9.}

\item{dir}{Path to folder containing \code{infile}s. \cr Default is \code{getOption('lingmatch.lspace.dir')},
which must be set in the current session. If this is not specified and \code{infile} is a full path,
\code{dir} will be set to \code{infile}'s parent directory.}

\item{outdir}{Path to folder in which to save standardized files; default is \code{dir}.}

\item{remove}{A string with a regex pattern to be removed from term names \cr (i.e., \code{gsub(remove,}
\code{"", term)}); default is \code{""}, which is ignored.}

\item{term_check}{A string with a regex pattern by which to filter terms; i.e., only lines with fully
matched terms are written to the reformatted file. The default attempts to retain only regular words, including
those with dashes, foreword slashes, and periods. Set to an empty string (\code{""}) to write all lines
regardless of term.}

\item{verbose}{Logical: if \code{TRUE}, prints the current line number and its term to the console every 1,000 lines.
Only applies to plain-text files.}
}
\value{
Path to the standardized [1] data file and [2] terms file if applicable.
}
\description{
Reformat a .rda file which has a matrix with terms as row names, or a plain-text embeddings file
which has a term at the start of each line, and consistent delimiting characters. Plain-text files
are processed line-by-line, so large spaces can be reformatted RAM-conservatively.
}
\examples{
\dontrun{

# from https://sites.google.com/site/fritzgntr/software-resources/semantic_spaces
standardize.lspace('EN_100k_lsa.rda', '100k_lsa')

# from https://fasttext.cc/docs/en/english-vectors.html
standardize.lspace('crawl-300d-2M.vec', 'facebook_crawl')

# Standardized versions of these spaces can also be downloaded with download.lspace.

}
}
\seealso{
Other Latent Semantic Space functions: 
\code{\link{download.lspace}()},
\code{\link{lma_lspace}()},
\code{\link{select.lspace}()}
}
\concept{Latent Semantic Space functions}
