% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast.R
\name{Forecast}
\alias{Forecast}
\title{Create an object of the Forecast class}
\usage{
Forecast(origin, future, forecast, realized = NULL, h_ahead = NULL)
}
\arguments{
\item{origin}{A vector of any class representing the time when the forecast
was made.}

\item{future}{A vector of any class representing the time that is being
forecasted, i.e. when the forecast will be realized.}

\item{forecast}{A numeric vector of forecasts.}

\item{realized}{Optional numeric vector of realized values, i.e. the true
value at the future time.}

\item{h_ahead}{Optional length-one object representing the number of periods
ahead being forecasted.}
}
\description{
An S4 class for storing forecasts. An object of the Forecast class has equal
length vectors that contain the time the forecast was made, the future time
being forecasted, the forecast, and realized values if available. Optionally
includes the number of periods ahead being forecasted.
}
\examples{
my_forecast <- Forecast(
   origin   = c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31"),
   future   = c("2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31"),
   forecast = c(4.21, 4.27, 5.32, 5.11),
   realized = c(4.40, 4.45, 4.87, 4.77),
   h_ahead  = 4L
)

origin(my_forecast) <- c("2010-04-01", "2010-07-01", "2010-10-01", "2011-01-01")
future(my_forecast) <- c("2012-04-01", "2012-07-01", "2012-10-01", "2013-01-01")
forc(my_forecast) <- c(8.87, 7.61, 7.56, 5.96)
realized(my_forecast) <- c(6.64, 6.10, 6.33, 6.67)
h_ahead(my_forecast) <- 8L

origin(my_forecast)
future(my_forecast)
forc(my_forecast)
realized(my_forecast)
h_ahead(my_forecast)

}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
