% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localStrat.r
\name{grMatrix}
\alias{grMatrix}
\title{Cpp implementation of the genomic relationship matrix (grm) for a (sparse) input matrix as defined in Wang et.al. (2017).}
\usage{
grMatrix(m, dense = FALSE, robust = TRUE)
}
\arguments{
\item{m}{A (sparse) matrix for which the genomic relationship matrix is sought. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{dense}{Flag to switch between purpose-built dense or sparse implementations. Default is \code{dense=FALSE}.}

\item{robust}{Flag to indicate if the classic (\code{robust=FALSE}) or robust (\code{robust=TRUE}) version of the grm matrix is sought. Default is \code{robust=TRUE}.}
}
\value{
The genomic relationship matrix of \code{m}.
}
\description{
Cpp implementation of the genomic relationship matrix (grm) for a (sparse) input matrix as defined in Wang et.al. (2017).
}
\examples{
library(locStra)
library(Matrix)
m <- matrix(sample(0:1,15,replace=TRUE),ncol=3)
sparseM <- Matrix(m,sparse=TRUE)
print(grMatrix(sparseM))

}
\references{
Bowen Wang, Serge Sverdlov and Elizabeth Thompson (2017). Efficient Estimation of Realized Kinship from Single Nucleotide Polymorphism Genotypes. Genetics, 205(3):1063-1078.
}
