% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localStrat.r
\name{fullscan}
\alias{fullscan}
\title{Main function: A full scan of the input data \code{m} using a collection of windows given by the two-column matrix \code{windows}. For each window, the data is processed using the function \code{matrixFunction} (this could be e.g. the \code{covMatrix} function), then the processed data is summarised using the function \code{summaryFunction} (e.g., the largest eigenvector computed with the function \code{powerMethod}), and finally the global and local summary scores (e.g., the largest eigenvectors) are compared using the function \code{comparisonFunction} (e.g., the vector correlation with R's function \code{cor}). The function returns a two-column matrix which contains per row the global (e.g., the correlation between global and local eigenvectors) and local (e.g., the correlation between the local eigenvector for the current window and the eigenvector for the last window) summary statistics for each window.}
\usage{
fullscan(m, windows, matrixFunction, summaryFunction, comparisonFunction)
}
\arguments{
\item{m}{A (sparse) matrix for which the full scan is sought. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{windows}{A two-column matrix containing per column the windows on which the data is scanned. The windows can be overlapping. The windows can be computed using the function \code{makeWindows}.}

\item{matrixFunction}{Function on one matrix argument to process the data for each window (e.g., the covariance matrix).}

\item{summaryFunction}{Function on one argument to summarise the output of the function \code{matrixFunction} (e.g., the largest eigenvector).}

\item{comparisonFunction}{Function on two inputs to compute some kind of comparison measure for the output of the function \code{summaryFunction} (e.g., vector correlation, or matrix norm).}
}
\value{
A two-column matrix containing per row the global and local summary statistics for each window.
}
\description{
Main function: A full scan of the input data \code{m} using a collection of windows given by the two-column matrix \code{windows}. For each window, the data is processed using the function \code{matrixFunction} (this could be e.g. the \code{covMatrix} function), then the processed data is summarised using the function \code{summaryFunction} (e.g., the largest eigenvector computed with the function \code{powerMethod}), and finally the global and local summary scores (e.g., the largest eigenvectors) are compared using the function \code{comparisonFunction} (e.g., the vector correlation with R's function \code{cor}). The function returns a two-column matrix which contains per row the global (e.g., the correlation between global and local eigenvectors) and local (e.g., the correlation between the local eigenvector for the current window and the eigenvector for the last window) summary statistics for each window.
}
\examples{
library(locStra)
m <- matrix(sample(0:1,1000,replace=TRUE),ncol=10)
w <- makeWindows(nrow(m),10,10)
print(fullscan(m,w,covMatrix,powerMethod,cor))

}
\references{
Dmitry Prokopenko, Julian Hecker, Edwin Silverman, Marcello Pagano, Markus Noethen, Christian Dina, Christoph Lange and Heide Fier (2016). Utilizing the Jaccard index to reveal population stratification in sequencing data: a simulation study and an application to the 1000 Genomes Project. Bioinformatics, 32(9):1366-1372.
}
