% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{inv.logit.mat}
\alias{inv.logit.mat}
\title{Inverse logit for matrices}
\usage{
inv.logit.mat(x, min = 0, max = 1)
}
\arguments{
\item{x}{matrix}

\item{min}{Lower end of logit interval}

\item{max}{Upper end of logit interval}
}
\description{
Apply the inverse logit function to a matrix, element-wise. It
generalizes the \code{inv.logit} function from the \code{gtools}
library to matrices
}
\examples{
(mat = matrix(rnorm(10 * 5), nrow = 10, ncol = 5))
inv.logit.mat(mat)
}

