% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{pextweibull}
\alias{pextweibull}
\alias{dextweibull}
\alias{hextweibull}
\alias{qextweibull}
\title{Distribution function of the extended Weibull distribution}
\usage{
pextweibull(
  q,
  scale = 1,
  shape1 = 0,
  shape2 = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

dextweibull(x, scale = 1, shape1 = 0, shape2 = 1, log = FALSE)

hextweibull(x, scale = 1, shape1 = 0, shape2 = 1, log = FALSE)

qextweibull(p, scale = 1, shape1 = 0, shape2 = 1, lower.tail = TRUE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{scale}{scale parameter, strictly positive.}

\item{shape1}{shape parameter of the generalized Pareto component.}

\item{shape2}{shape parameter of the Weibull component.}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{log.p}{logical; if \code{FALSE} (default), values are returned on the probability scale.}

\item{x}{vector of quantiles.}

\item{log}{logical; if \code{FALSE} (default), return the hazard, else the log hazard.}

\item{p}{vector of probabilities.}
}
\value{
a vector of (log)-probabilities of the same length as \code{q}

a vector of (log)-density.

a vector of (log)-hazard

vector of quantiles

a vector of quantiles
}
\description{
Distribution function of the extended Weibull distribution

Density function of the extended Weibull distribution

Hazard function of the extended Weibull distribution

Quantile function of the extended Weibull distribution
}
\keyword{internal}
