% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longurl.r
\name{expand_urls}
\alias{expand_urls}
\title{Expand a vector of (short) URLs using the URL-Expander service}
\usage{
expand_urls(urls_to_expand, check = FALSE, warn = TRUE,
  .progress = interactive())
}
\arguments{
\item{urls_to_expand}{character vector of URLs}

\item{check}{run an extra \code{HEAD} request on the expanded URL to determine
validity. This is an expensive operation, so recommended usage is to run
this only on URLs that did not seem to expand.}

\item{warn}{show any warnings (API or otherwise) as messages}

\item{.progress}{display a progress bar (generally only useful in
interactive sesions)}
}
\value{
\code{data_frame} (compatible with \code{data.frame}) of results
       with the orignial URLs in \code{orig_url} and expanded URLs in
       \code{expanded_url})
}
\description{
Pass in a vector of URLs (ostensibly "short" URLs) and receive
a \code{data_frame} of the original URLs and expanded URLs via the
'URL-Expander' service.
}
\note{
max 10,000 expansions per day
}
\examples{
test_urls <- c("http://t.co/D4C7aWYIiA",
               "1.usa.gov/1J6GNoW",
               "ift.tt/1L2Llfr")
big_urls <- expand_urls(test_urls)
head(big_urls)
}

