% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_line}
\alias{l_layer_line}
\title{Layer a line}
\usage{
l_layer_line(widget, x, y = NULL, color = "black", linewidth = 1,
  dash = "", label = "line", parent = "root", index = 0, ...)
}
\arguments{
\item{widget}{widget path name as a string}

\item{x}{the coordinates of line. Alternatively, a single plotting structure,
function or any \emph{R} object with a plot method can be provided as x and
y are passed on to \code{\link{xy.coords}}}

\item{y}{the y coordinates of the line, optional if x is an appropriate 
structure.}

\item{color}{color of line}

\item{linewidth}{linewidth of outline}

\item{dash}{dash pattern of line, see 
\url{https://www.tcl.tk/man/tcl8.6/TkCmd/canvas.htm#M26}}

\item{label}{label used in the layers inspector}

\item{parent}{group layer}

\item{index}{of the newly added layer in its parent group}

\item{...}{additional state initialization arguments, see 
\code{\link{l_info_states}}}
}
\value{
layer object handle, layer id
}
\description{
Loon's displays that are based on Cartesian coordinates (i.e.
  scatterplot, histogram and graph display) allow for layering visual
  information including polygons, text and rectangles.
}
\details{
For more information run: \code{l_help("learn_R_layer")}
}
\examples{

p <- l_plot()
l <- l_layer_line(p, x=c(1,2,3,4), y=c(1,3,2,4), color='red', linewidth=2)
l_scaleto_world(p)

# object
p <- l_plot()
l <- l_layer_line(p, x=nhtemp)
l_scaleto_layer(l)

}
\seealso{
\code{\link{l_layer}}, \code{\link{l_info_states}}
}
