% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_functions.R
\name{admm_algorithm}
\alias{admm_algorithm}
\title{Performs the Alternating Descent Method of Multipliers (ADMM) algorithm to estimate the LoRI parameters.}
\usage{
admm_algorithm(Y, cov = FALSE, lambda = NULL,
  projection = default_projection, gamma_init = NULL, X_init = NULL,
  Theta_init = NULL, tau = 0.1, epsilon = 1e-06, tol = 1e-12,
  max_it = 5 * 1e+05, upper = -log(1e-06), lower = log(1e-06))
}
\arguments{
\item{Y}{A matrix of counts (same size as X).}

\item{cov}{A boolean \code{TRUE} if covariate matrices are provided, \code{FALSE} otherwise. Default is \code{FALSE}.}

\item{lambda}{A number, the regularization parameter.}

\item{projection}{A projection function - identifiability constraint - by default centers by rows and columns.}

\item{gamma_init}{A matrix - initial dual variable, same size as X_init.}

\item{X_init}{A matrix - initial Poisson parameter matrix, same size as Y.}

\item{Theta_init}{A matrix - initial interaction matrix, same size as X_init.}

\item{tau}{A number (augmented Lagrangian parameter).}

\item{epsilon}{A number - convergence tolerance of ADMM, by default \code{1e-6}.}

\item{tol}{A number - convergence of gradient descent in ADMM iteration in \code{X}. By default\code{1e-12}.}

\item{max_it}{An integer. Maximum allowed number of iterations.}

\item{upper}{upper bound on the values of \code{X}.}

\item{lower}{lower bound on the values of \code{X}.}
}
\value{
The value of the augmented Lagrangian (with fixed \code{Theta} and \code{gamma}) taken at \code{X}.
}
\description{
Performs the Alternating Descent Method of Multipliers (ADMM) algorithm to estimate the LoRI parameters.
}
\examples{
\dontshow{
X = matrix(rnorm(rep(0, 15)), 5)
Y <- matrix(rpois(length(c(X)), exp(c(X))), 5)
res_admm <- admm_algorithm(Y)
}
}
