% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_header.R
\name{create_header}
\alias{create_header}
\title{Create a new LPJmL input/output file header}
\usage{
create_header(
  name = "LPJGRID",
  version = 3,
  order = 1,
  firstyear = 1901,
  nyear = 1,
  firstcell = 0,
  ncell,
  nbands = 2,
  cellsize_lon = 0.5,
  scalar = 1,
  cellsize_lat = cellsize_lon,
  datatype = 3,
  nstep = 1,
  timestep = 1,
  endian = .Platform$endian,
  verbose = TRUE
)
}
\arguments{
\item{name}{Header name attribute (default: `"LPJGRID").}

\item{version}{CLM version to use (default: \code{3}).}

\item{order}{Order of data items. See details below or LPJmL code for
supported values. The order may be provided either as an integer value or
as a character string (default: \code{1}).}

\item{firstyear}{Start year of data in file (default: \code{1901}).}

\item{nyear}{Number of years of data included in file (default: \code{1}).}

\item{firstcell}{Index of first data item (default: \code{0}).}

\item{ncell}{Number of data items per band.}

\item{nbands}{Number of bands per year of data (default: \code{2}).}

\item{cellsize_lon}{Longitude cellsize in degrees (default: \code{0.5}).}

\item{scalar}{Conversion factor applied to data when it is read by LPJmL or
by \code{read_io()} (default: \code{1.0}).}

\item{cellsize_lat}{Latitude cellsize in degrees (default: same as
\code{cellsize_lon}).}

\item{datatype}{LPJmL data type in file. See details below or LPJmL code for
valid data type codes (default: \code{3}).}

\item{nstep}{Number of time steps per year. Added in header version 4 to
separate time bands from content bands (default: \code{1}).}

\item{timestep}{If larger than 1, outputs are averaged over \code{timestep} years
and only written once every \code{timestep} years (default: \code{1}).}

\item{endian}{Endianness to use for file (either \code{"big"} or \code{"little"}, by
default uses platform-specific endianness \code{.Platform$endian}).}

\item{verbose}{If \code{TRUE} (the default), function provides some feedback on
datatype and when using default values for missing parameters. If \code{FALSE},
only errors are reported.}
}
\value{
The function returns a list with 3 components:
\itemize{
\item name: The header name, e.g. "LPJGRID".
\item header: Vector of header values ('version', 'order', 'firstyear',
'nyear', 'firstcell', 'ncell', 'nbands', 'cellsize_lon', 'scalar',
'cellsize_lat', 'datatype', 'nstep', 'timestep').
\item endian: Endian used to write binary data, either "little" or "big".
}
}
\description{
Create a header from scratch in the format required by
\code{\link[=write_header]{write_header()}}.
}
\details{
File headers in input files are used by LPJmL to determine the
structure of the file and how to read it. They can also be used to describe
the structure of output files.

Header names usually start with "LPJ" followed by a word or abbreviation
describing the type of input/output data. See LPJmL code for valid header
names.

The version number determines the amount of header information included in
the file. All versions save the header name and header attributes 'version',
'order', 'firstyear', 'nyear', 'firstcell', 'ncell', and 'nbands'. Header
versions 2, 3 and 4 add header attributes 'cellsize_lon' and 'scalar'. Header
versions 3 and 4 add header attributes 'cellsize_lat' and 'datatype'. Header
version 4 adds attributes 'nstep' and 'timestep'.

Valid values for \code{order} are \code{1} / \code{"cellyear"}, \code{2} / \code{"yearcell"}, \code{3} /
\code{"cellindex"}, and \code{4} / \code{"cellseq"}. The default for LPJmL input files is
\code{1}. The default for LPJmL output files is \code{4}, except for grid output
files which also use \code{1}.

By default, input files contain data for all cells, indicated by setting
the \code{firstcell} index to \code{0}. If \code{firstcell > 0}, LPJmL assumes the first
\code{firstcell} cells to be missing in the data.

Valid codes for the \code{datatype} attribute and the corresponding LPJmL data
types are: \code{0} / \code{"byte"} (LPJ_BYTE), \code{1} / \code{"short"} (LPJ_SHORT), \code{2} /
\code{"int"} (LPJ_INT), \code{3} / \code{"float"} (LPJ_FLOAT), \code{4} / \code{"double"}
(LPJ_DOUBLE).

The default parameters of the function are valid for grid input files using
LPJ_FLOAT data type.
}
\examples{
header <- create_header(
  name = "LPJGRID",
  version = 3,
  order = 1,
  firstyear = 1901,
  nyear = 1,
  firstcell = 0,
  ncell = 67420,
  nbands = 2,
  cellsize_lon = 0.5,
  scalar = 1.0,
  cellsize_lat = 0.5,
  datatype = 3,
  nstep = 1,
  timestep = 1,
  endian = .Platform$endian,
  verbose = TRUE
)

}
\seealso{
\itemize{
\item \code{\link[=read_header]{read_header()}} for reading headers from LPJmL input/output files.
\item \code{\link[=write_header]{write_header()}} for writing headers to files.
}
}
