% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{findInterval2}
\alias{findInterval2}
\title{Find interval numbers of indices}
\usage{
findInterval2(x, breaks)
}
\arguments{
\item{x}{The numeric vector of interest.}

\item{breaks}{The vector of break points.}
}
\value{
A vector of length(x) with values in 0:N where N <- length(breaks).
}
\description{
The implementation of findInterval() in R from Advanced R by
Hadley Wickham. Given a vector of non-decreasing breakpoints in breaks,
find the interval containing each element of x; i.e., if
i <- findInterval2(x,v), for each index j in x, v[i[j]] ≤ x[j] < v[i[j] + 1]
where v[0] := -Inf, v[N+1] := +Inf, and N <- length(v).
}
\examples{
x <- 2:18
v <- c(5, 10, 15) # create two bins [5,10) and [10,15)
cbind(x, findInterval2(x, v))

}
\keyword{internal}
