% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrsim}
\alias{lrsim}
\title{Log-rank test simulation}
\usage{
lrsim(
  kMax = NA_integer_,
  informationRates = NA_real_,
  criticalValues = NA_real_,
  futilityBounds = NA_real_,
  allocation1 = 1L,
  allocation2 = 1L,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  plannedEvents = NA_integer_,
  maxNumberOfIterations = 1000L,
  maxNumberOfRawDatasetsPerStage = 0L,
  seed = NA_integer_
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates fixed prior to the trial.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., kMax-1. Defaults to
\code{rep(-Inf, kMax-1)} if left unspecified.}

\item{allocation1}{Number of subjects in the active treatment group in
a randomization block. Defaults to 1 for equal randomization.}

\item{allocation2}{Number of subjects in the control group in
a randomization block. Defaults to 1 for equal randomization.}

\item{accrualTime}{Accrual time intervals, must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities, one for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for
the piecewise exponential survival distribution, must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event for the
active treatment group, one for each analysis time interval, by stratum.}

\item{lambda2}{A vector of hazard rates for the event for the
control group, one for each analysis time interval, by stratum.}

\item{gamma1}{The hazard rate for exponential dropout or a vector of hazard
rates for piecewise exponential dropout for the active treatment group.
Defaults to 0 for no dropout.}

\item{gamma2}{The hazard rate for exponential dropout or a vector of hazard
rates for piecewise exponential dropout for the control group.
Defaults to 0 for no dropout.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{First parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{Second parameter of the Fleming-Harrington family of weighted
log-rank test. Defaults to 0 for conventional log-rank test.}

\item{plannedEvents}{The planned cumulative total number of events at each
stage.}

\item{maxNumberOfIterations}{The number of simulation iterations.
Defaults to 1000.}

\item{maxNumberOfRawDatasetsPerStage}{The number of raw datasets per stage
to extract. Defaults to 1.}

\item{seed}{The seed to reproduce the simulation results.
The computer clock will be used if left unspecified,}
}
\value{
A list of S3 class lrsim with 3 components: sumstat is a list of
the operating characteristics of the design, sumdata is a data frame for
the summary data for each iteration, and rawdata is a data frame for
selected raw data if maxNumberOfRawDatasetsPerStage is a positive integer.
}
\description{
Performs simulation for two-arm group sequential superiority
trials based on log-rank test.
}
\examples{
sim = lrsim(kMax = 2, informationRates = c(0.5, 1),
            criticalValues = c(2.797, 1.977),
            accrualIntensity = 11,
            lambda1 = 0.018, lambda2 = 0.030,
            accrualDuration = 12,
            plannedEvents = c(60, 120),
            maxNumberOfIterations = 1000,
            maxNumberOfRawDatasetsPerStage = 1,
            seed = 314159)

# summary statistics
sim

# summary for each simulated data set
head(sim$sumdata)

# raw data for selected replication
head(sim$rawdata)

}
