% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{lsgl.algorithm.config}
\alias{lsgl.algorithm.config}
\title{Create a new algorithm configuration}
\usage{
lsgl.algorithm.config(tolerance_penalized_main_equation_loop = 1e-10,
  tolerance_penalized_inner_loop_alpha = 1e-04,
  tolerance_penalized_inner_loop_beta = 1,
  tolerance_penalized_middel_loop_alpha = 0.01,
  tolerance_penalized_outer_loop_alpha = 0.01,
  tolerance_penalized_outer_loop_beta = 0,
  tolerance_penalized_outer_loop_gamma = 1e-05,
  use_bound_optimization = FALSE,
  use_stepsize_optimization_in_penalizeed_loop = TRUE,
  stepsize_opt_penalized_initial_t = 1, stepsize_opt_penalized_a = 0.1,
  stepsize_opt_penalized_b = 0.1, max_iterations_outer = 10000,
  inner_loop_convergence_limit = 1e+05, verbose = TRUE)
}
\arguments{
\item{tolerance_penalized_main_equation_loop}{tolerance threshold.}

\item{tolerance_penalized_inner_loop_alpha}{tolerance threshold.}

\item{tolerance_penalized_inner_loop_beta}{tolerance threshold.}

\item{tolerance_penalized_middel_loop_alpha}{tolerance threshold.}

\item{tolerance_penalized_outer_loop_alpha}{tolerance threshold.}

\item{tolerance_penalized_outer_loop_beta}{tolerance threshold.}

\item{tolerance_penalized_outer_loop_gamma}{tolerance threshold.}

\item{use_bound_optimization}{if \code{TRUE} hessian bound check will be used.}

\item{use_stepsize_optimization_in_penalizeed_loop}{if \code{TRUE} step-size optimization will be used.}

\item{stepsize_opt_penalized_initial_t}{initial step-size.}

\item{stepsize_opt_penalized_a}{step-size optimization parameter.}

\item{stepsize_opt_penalized_b}{step-size optimization parameter.}

\item{max_iterations_outer}{max iteration of outer loop}

\item{inner_loop_convergence_limit}{inner loop convergence limit.}

\item{verbose}{If \code{TRUE} some information, regarding the status of the algorithm, will be printed in the R terminal.}
}
\value{
A configuration.
}
\description{
With the exception of \code{verbose} it is not recommended to change any of the default values.
}
\examples{

set.seed(100) # This may be removed, it ensures consistency of the daily tests

## Simulate from Y=XB+E, the dimension of Y is N x K, X is N x p, B is p x K

N <- 50 #number of samples
p <- 50 #number of features
K <- 25  #number of groups

B<-matrix(sample(c(rep(1,p*K*0.1),rep(0, p*K-as.integer(p*K*0.1)))),nrow=p,ncol=K)

X<-matrix(rnorm(N*p,1,1),nrow=N,ncol=p)
Y<-X\%*\%B+matrix(rnorm(N*K,0,1),N,K)

# Create configuration
config <- lsgl.algorithm.config(verbose = FALSE)

lambda<-lsgl::lambda(X,Y, alpha=1, lambda.min=.5, intercept=FALSE, algorithm.config = config)

fit <-lsgl::fit(X,Y, alpha=1, lambda = lambda, intercept=FALSE, algorithm.config = config)
}
\author{
Martin Vincent
}

