% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsjm.R
\name{lsjm}
\alias{lsjm}
\title{Latent Space Joint Model}
\usage{
lsjm(Y, D, sigma = 1, xi = rep(0, length(Y)), psi2 = rep(2,
  length(Y)), Niter = 500, tol = 0.1^2, preit = 20,
  randomZ = FALSE)
}
\arguments{
\item{Y}{list containing a (\code{N} x \code{N}) binary adjacency matrix for each network view.}

\item{D}{integer dimension of the latent space}

\item{sigma}{(\code{D} x \code{D}) variance/covariance matrix of the prior distribution for the latent positions. Default \code{sigma = 1}}

\item{xi}{vector of means of the prior distributions of \eqn{\alpha}. Default \code{xi = 0}}

\item{psi2}{vector of variances of the prior distributions of \eqn{\alpha}. Default \code{psi2 = 2}}

\item{Niter}{maximum number of iterations. Default \code{Niter = 500}}

\item{tol}{desired tolerance. Default \code{tol = 0.1^2}}

\item{preit}{Preliminary number of iterations default \code{preit = 20}}

\item{randomZ}{logical; If \code{randomZ = TRUE} random initialization for the latent positions is used. If \code{randomZ = FALSE} and \code{D} = 2 or 3 the latent positions are initialized using the Fruchterman-Reingold method and multidimensional scaling is used for \code{D} = 1 or \code{D} > 3. Default \code{randomZ = FALSE}
 @return List containing:
\itemize{
\item \code{EZ} (\code{N} x \code{D}) matrix containing the posterior means of the latent positions
\item \code{VZ} (\code{D} x \code{D}) matrix containing the posterior variance of the latent positions
\item \code{lsmEZ} list contatining a (\code{N} x \code{D}) matrix for each network view containing the posterior means of the latent positions under each model in the latent space.
\item \code{lsmVZ} list contatining a (\code{D} x \code{D}) matrix for each network view containing the posterior variance of the latent positions under each model in the latent space.
\item \code{xiT} vector of means of the posterior distributions of \eqn{\alpha}
\item \code{psi2T} vector of variances of the posterior distributions of \eqn{\alpha}
\item \code{Ell} expected log-likelihood
}}
}
\description{
Function to joint modelling of multiple network views using the Latent Space Jont Model (LSJM) Gollini and Murphy (2016). 
The LSJM merges the information given by the multiple network views by assuming that the probability of a node being connected with other nodes in each view is explained by a unique latent variable.
}
\examples{
## Simulate Undirected Network
  N <- 20
  Ndata <- 2
   Y <- list()
   Y[[1]] <- network(N, directed = FALSE)[,]
   ### create a new view that is similar to the original
   
  for(nd in 2:Ndata){
    Y[[nd]] <- Y[[nd - 1]] - sample(c(-1, 0, 1), N * N, replace = TRUE, 
   prob = c(.05, .85, .1))
    Y[[nd]] <- 1 * (Y[[nd]]  > 0 )
  diag(Y[[nd]]) <- 0
   }

par(mfrow = c(1, 2))
z <- plotY(Y[[1]], verbose = TRUE, main = 'Network 1')
plotY(Y[[2]], EZ = z, main = 'Network 2')
par(mfrow = c(1, 1))

modLSJM <- lsjm(Y, D = 2) 
plot(modLSJM, Y, drawCB = TRUE)
plot(modLSJM, Y, drawCB = TRUE, plotZtilde = TRUE)
}
\references{
Gollini, I., and Murphy, T. B. (2016), 'Joint Modelling of Multiple Network Views', Journal of Computational and Graphical Statistics, 25(1), 246-265 \url{http://arxiv.org/abs/1301.3759}.
}
