% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooling-basic-funs.R
\name{mmpa}
\alias{mmpa}
\title{Number of Assays Required using Marker-Assisted Mini-Pooling with Algorithm
(mMPA)}
\usage{
mmpa(v, s, K = 5, vf_cut = 1000, lod = 0, msg = T)
}
\arguments{
\item{v}{A vector of non-negative numerical assay results.}

\item{s}{A vector of risk scores; \code{s} must have the same
length as \code{v}. The risk score \code{s} needs to be positively
associated with \code{v}; othewise an error message will be generated.}

\item{K}{Pool size; default is \code{K = 5}.}

\item{vf_cut}{Cutoff value for defining positive cases;
default is \code{vf_cut = 1000}.}

\item{lod}{A vector of lower limits of detection or a scalar if the limits are the
same; default is \code{lod = 0}.}

\item{msg}{Message generated during calculation; default is \code{TRUE}.}
}
\value{
A vectorof length \code{N\%/\%K} for the numbers of assays needed for all pools
that are formed.
}
\description{
Function \code{mmpa(...)} calculates the number of assays required, when
using mMPA, for
pools that are formed following the order of individual samples in the data.
}
\details{
For a given sample (v_i, s_i), i = 1, ..., N, the first \code{K} samples are combined to
form a pool, the next \code{K} samples are combined to form the second
pool, and so on. If the number of samples for the last pool is less than
\code{K}, these remaining samples are not used to form a pool (i.e.
not included
in the calculation) . Therefore, a total of
\code{N\%/\%K} pools are formed. The function calculates the number of
assays needed for each of these pools.
}
\examples{
K=5; n = 50;
n.pool  = n/K; n.pool
#   [1] 10
set.seed(100)
pvl = rgamma(n, shape = 2.8, scale = 150)
riskscore = (rank(pvl)/n) * 0.5 + runif(n) * 0.5
mmpa(v = pvl, s = riskscore)
#   A total of 10 pools are formed.
#   The numbers of assays required by these pools are:
#   [1] 3 3 4 4 2 3 3 4 3 3

}
\references{
Bilder CR, Tebbs JM, Chen P. Informative retesting. Journal of the American
Statistical Association. 2010;105(491):942-955.

May S, Gamst A, Haubrich R, Benson C, Smith DM. Pooled nucleic acid testing
to identify antiretroviral treatment failure during HIV infection. Journal
of Acquired Immune Deficiency Syndromes. 2010;53(2):194-201.

Our manuscript (under review);  to be added.
}
\seealso{
\link{minipool}, \link{mpa}, \link{pooling_mc}
}
\keyword{mMPA.}
