% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-helper.R
\name{set_time_conversion}
\alias{set_time_conversion}
\alias{get_time_conversion}
\title{Get and Set Time Conversion Factors}
\usage{
set_time_conversion(
  default = "days",
  days = 1,
  weeks = 7,
  months = 365.25/12,
  years = 365.25
)

get_time_conversion(factor = c("days", "weeks", "months", "years"))
}
\arguments{
\item{default}{The default time scale, commonly whichever has factor = 1}

\item{days}{Factor to divide data time units to get time in days}

\item{weeks}{Factor to divide data time units to get time in weeks}

\item{months}{Factor to divide data time units to get time in months}

\item{years}{Factor to divide data time units to get time in years}

\item{factor}{Time factor to get.}
}
\value{
No value returned. Conversion factors are stored internally and used within functions.
}
\description{
Get and Set Time Conversion Factors
}
\examples{
# The default time scale is days:
set_time_conversion(default = "days", days = 1, weeks = 7, months = 365.25 / 12, years = 365.25)

# Set the default time scale to years
set_time_conversion(
  default = "years",
  days = 1 / 365.25,
  weeks = 1 / 52.17857,
  months = 1 / 12,
  years = 1
)

# Get time scale factors:
get_time_conversion("years")
get_time_conversion("weeks")
}
