% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spectra_names.R
\name{get_spectra_names}
\alias{get_spectra_names}
\title{Extract spectra names and check for uniqueness}
\usage{
get_spectra_names(spectra_list)
}
\arguments{
\item{spectra_list}{A list of \link[MALDIquant:MassSpectrum-class]{MALDIquant::MassSpectrum} objects.}
}
\value{
A tibble with four columns
\itemize{
\item \code{sanitized_name}: spectra names based on \code{fullName} where dots and dashes are converted to underscores
\item \code{name}: spectra name using the \code{name} label in the spectra metadata
\item \code{fullName}: spectra full name using the \code{fullName} label in the spectra metadata
\item \code{file}: the path to the raw spectra data
}
}
\description{
Given the list of raw spectra, \code{get_spectra_names()} extracts the spectra names
using the file metadata, and warns if the associated sanitized names are not unique.
}
\examples{
# Get an example directory of six Bruker MALDI Biotyper spectra
directory_biotyper_spectra <- system.file(
  "toy-species-spectra",
  package = "maldipickr"
)
# Import the six spectra
spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)
# Extract the names
get_spectra_names(spectra_list)

# Artificially create duplicated entries to show the warning
get_spectra_names(spectra_list[c(1,1)])
}
