% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_spede_clusters.R
\name{import_spede_clusters}
\alias{import_spede_clusters}
\title{Import clusters results generated by SPeDE}
\usage{
import_spede_clusters(path)
}
\arguments{
\item{path}{Path to the comma separated table generated by SPeDE}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{name}: a character denoting the spectra name (all spaces, dashes and dots are replaced by underscores "_" in SPeDE)
\item \code{membership}: integers stating the cluster number to which the spectra belong to. It starts from 1 to \emph{c}, the total number of clusters.
\item \code{cluster_size}: integers indicating the total number of spectra in the corresponding cluster.
\item \code{quality}: a character indicating the spectra quality category by SPeDE, out of GREEN, ORANGE and RED.
\item \code{is_reference}: a logical indicating whether the corresponding spectra is a reference spectra of the cluster.
}
}
\description{
Reformat the table output from the analysis of raw Bruker MALDI Biotyper
spectra by the SPeDE tool from Dumolin et al. (2019) to be consistent with the Strejcek et al. (2018) procedure followed
in the \link{maldipickr} package.
}
\examples{
# Reformat the output from SPeDE table
# https://github.com/LM-UGent/SPeDE
import_spede_clusters(
  system.file("spede.csv", package = "maldipickr")
)
}
\references{
Dumolin C, Aerts M, Verheyde B, Schellaert S, Vandamme T, Van Der Jeugt F, De Canck E, Cnockaert M, Wieme AD, Cleenwerck I, Peiren J, Dawyndt P, Vandamme P, & Carlier A. (2019). "Introducing SPeDE: High-Throughput Dereplication and Accurate Determination of Microbial Diversity from Matrix-Assisted Laser Desorption–Ionization Time of Flight Mass Spectrometry Data". \emph{MSystems} 4(5). \url{doi:10.1128/msystems.00437-19}.
}
\seealso{
\url{https://github.com/LM-UGent/SPeDE}
}
