% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_biotyper_report.R
\name{read_biotyper_report}
\alias{read_biotyper_report}
\title{Importing Bruker MALDI Biotyper CSV report}
\usage{
read_biotyper_report(path, best_hits = TRUE, long_format = TRUE)
}
\arguments{
\item{path}{Path to the semi-colon separated table}

\item{best_hits}{A logical indicating whether to return only the best hits for each target analyzed}

\item{long_format}{A logical indicating whether the table is in the long format (many rows) or wide format (many columns) when showing all the hits. This option has no effect when \code{best_hits = TRUE}.}
}
\value{
A tibble of 7 columns (\code{best_hits = TRUE}) or 52 columns (\code{best_hits = FALSE}). See Details for the description of the columns.
}
\description{
The header-less table exported by the Compass software in the Bruker MALDI
Biotyper device is separated by semi-colons and has empty columns which prevent
an easy import in R. This function reads the report correctly as a tibble.
}
\details{
The header-less table contains identification information for each target processed by
the Biotyper device and once processed by the \code{read_biotyper_report},
the following seven columns are available in the tibble, \emph{when using the \code{best_hits = TRUE} option}:
\itemize{
\item \code{name}: a character indicating the name of the spot of the MALDI target (i.e., plate)
\item \code{sample_name}: the character string provided during the preparation of the MALDI target (i.e., plate)
\item \code{hit_rank}: an integer indicating the rank of the hit for the corresponding target and identification
\item \code{bruker_quality}: a character encoding the quality of the identification with potentially multiple "+" symbol or only one "-"
\item \code{bruker_species}: the species name associated with the MALDI spectrum analyzed.
\item \code{bruker_taxid}: the NCBI Taxonomy Identifier of the species name in the column species
\item \code{bruker_hash}: a hash from an undocumented checksum function probably to encode the database entry.
\item \code{bruker_log}: the log-score of the identification.
}

When all hits are returned (with \code{best_hits = FALSE}), the default output format is the long format (\code{long_format = TRUE}), meaning that the previous columns remain
unchanged, but all hits are now returned, thus increasing the number of rows.

When all hits are returned (with \code{best_hits = FALSE}) \emph{using the wide format} (\verb{long_format = FALSE), the two columns }name\code{and}sample_name\verb{remains unchanged, but the five columns prefixed by}bruker_` contain the hit rank, \strong{creating a tibble of 52 columns}:
\itemize{
\item \code{bruker_01_quality}
\item \code{bruker_01_species}
\item \code{bruker_01_taxid}
\item \code{bruker_01_hash}
\item \code{bruker_01_log}
\item \code{bruker_02_quality}
\item ...
\item \code{bruker_10_species}
\item \code{bruker_10_taxid}
\item \code{bruker_10_hash}
\item \code{bruker_10_log}
}
}
\note{
A report that contains only spectra with no peaks found will return a tibble of 0 rows and a warning message.
}
\examples{
# Get a example Bruker report
biotyper <- system.file("biotyper.csv", package = "maldipickr")
# Import the report as a tibble
report_tibble <- read_biotyper_report(biotyper)
# Display the tibble
report_tibble
}
\seealso{
\link{read_many_biotyper_reports}
}
