/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import salvo.jesus.graph.java.awt.Fonts;
import salvo.jesus.util.StringComparator;

public class JFontChooser
extends JPanel {
    JComboBox fontscombo;
    JComboBox sizescombo;
    JComboBox stylescombo;
    private String[] fontsString;
    private static final String[] sizesString = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16"};
    private static final String[] stylesString = new String[]{"Plain", "Bold", "Italic", "Bold & Italic"};

    public JFontChooser() {
        this.initJFontChooser();
    }

    public JFontChooser(Font initialfont) {
        int fontIndex;
        Integer initialfontsize = new Integer(initialfont.getSize());
        this.initJFontChooser();
        if (initialfont == null) {
            initialfont = new Font("Lucida Sans", 0, 10);
        }
        if ((fontIndex = Arrays.binarySearch(this.fontsString, initialfont.getName(), new StringComparator())) < 0) {
            fontIndex = 0;
        }
        this.fontscombo.setSelectedIndex(fontIndex);
        this.stylescombo.setSelectedIndex(initialfont.getStyle());
        int sizeindex = Arrays.binarySearch(sizesString, initialfontsize.toString(), new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Integer i1 = new Integer((String)obj1);
                Integer i2 = new Integer((String)obj2);
                return i1 - i2;
            }
        });
        this.sizescombo.setSelectedIndex(sizeindex);
    }

    private void initJFontChooser() {
        Cursor originalcursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.fontsString = Fonts.instance().getFonts();
        this.setCursor(originalcursor);
        Arrays.sort(this.fontsString);
        this.fontscombo = new JComboBox<String>(this.fontsString);
        this.sizescombo = new JComboBox<String>(sizesString);
        this.stylescombo = new JComboBox<String>(stylesString);
        JPanel fontspanel = new JPanel();
        fontspanel.setLayout(new GridLayout(0, 1));
        fontspanel.add(new JLabel("Fonts"));
        fontspanel.add(this.fontscombo);
        JPanel sizescombopanel = new JPanel();
        sizescombopanel.setLayout(new GridLayout(0, 1));
        sizescombopanel.add(new JLabel("Size"));
        sizescombopanel.add(this.sizescombo);
        JPanel stylescombopanel = new JPanel();
        stylescombopanel.setLayout(new GridLayout(0, 1));
        stylescombopanel.add(new JLabel("Style"));
        stylescombopanel.add(this.stylescombo);
        JPanel sizescombotylepanel = new JPanel();
        sizescombotylepanel.setLayout(new BorderLayout());
        sizescombotylepanel.add((Component)sizescombopanel, "West");
        sizescombotylepanel.add((Component)stylescombopanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)fontspanel, "West");
        this.add((Component)sizescombotylepanel, "Center");
    }

    public Font getSelectedFont() {
        Integer size = new Integer((String)this.sizescombo.getSelectedItem());
        return new Font((String)this.fontscombo.getSelectedItem(), this.stylescombo.getSelectedIndex(), size);
    }
}

