/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.layout;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import salvo.jesus.graph.java.awt.geom.Point2DDouble;
import salvo.jesus.graph.visual.GraphEditor;
import salvo.jesus.graph.visual.GraphScrollPane;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.layout.AbstractGridLayout;

public class OrthogonalLineLayout
extends AbstractGridLayout {
    List topedges;
    List rightedges;
    List leftedges;
    List bottomedges;

    public OrthogonalLineLayout(VisualGraph vgraph) {
        super(vgraph);
    }

    public OrthogonalLineLayout(GraphScrollPane gpane) {
        super(gpane.getVisualGraph());
    }

    public OrthogonalLineLayout(GraphEditor gedit) {
        super(gedit.getVisualGraph());
    }

    protected void initGraphLayout() {
        int size = this.vgraph.getVisualVertices().size();
        this.topedges = new ArrayList(size);
        this.bottomedges = new ArrayList(size);
        this.leftedges = new ArrayList(size);
        this.rightedges = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.topedges.add(new ArrayList());
            this.bottomedges.add(new ArrayList());
            this.leftedges.add(new ArrayList());
            this.rightedges.add(new ArrayList());
        }
    }

    public void addVertex(VisualVertex vvertex) {
        if (!this.initialized) {
            return;
        }
        int index = this.vgraph.getVisualVertices().indexOf(vvertex);
        this.topedges.add(new ArrayList());
        this.bottomedges.add(new ArrayList());
        this.leftedges.add(new ArrayList());
        this.rightedges.add(new ArrayList());
    }

    public void removeVertex(VisualVertex vvertex) {
        if (!this.initialized) {
            return;
        }
        int index = this.vgraph.getVisualVertices().indexOf(vvertex);
        ((List)this.topedges.get(index)).clear();
        this.topedges.remove(index);
        ((List)this.bottomedges.get(index)).clear();
        this.bottomedges.remove(index);
        ((List)this.leftedges.get(index)).clear();
        this.leftedges.remove(index);
        ((List)this.rightedges.get(index)).clear();
        this.rightedges.remove(index);
    }

    public void addEdge(VisualEdge vedge) {
    }

    public void removeEdge(VisualEdge vedge) {
        if (!this.initialized) {
            return;
        }
        int fromindex = this.vgraph.getVisualVertices().indexOf(vedge.getVisualVertexA());
        int toindex = this.vgraph.getVisualVertices().indexOf(vedge.getVisualVertexB());
        List side = (List)this.topedges.get(fromindex);
        while (side.remove(vedge)) {
        }
        side = (List)this.bottomedges.get(fromindex);
        while (side.remove(vedge)) {
        }
        side = (List)this.leftedges.get(fromindex);
        while (side.remove(vedge)) {
        }
        side = (List)this.rightedges.get(fromindex);
        while (side.remove(vedge)) {
        }
        side = (List)this.topedges.get(toindex);
        while (side.remove(vedge)) {
        }
        side = (List)this.bottomedges.get(toindex);
        while (side.remove(vedge)) {
        }
        side = (List)this.leftedges.get(toindex);
        while (side.remove(vedge)) {
        }
        side = (List)this.rightedges.get(toindex);
        while (side.remove(vedge)) {
        }
    }

    public void routeEdge(Graphics2D g2d, VisualEdge vedge) {
        if (!this.initialized) {
            return;
        }
        int fromindex = this.vgraph.getVisualVertices().indexOf(vedge.getVisualVertexA());
        int toindex = this.vgraph.getVisualVertices().indexOf(vedge.getVisualVertexB());
        g2d.setColor(vedge.getOutlinecolor());
        Point2D.Double fromport = vedge.getFromPortAssignment();
        Point2D.Double toport = vedge.getToPortAssignment();
        Point2D.Double fromcenter = new Point2D.Double(vedge.getVisualVertexA().getBounds2D().getCenterX(), vedge.getVisualVertexA().getBounds2D().getCenterY());
        Point2D.Double tocenter = new Point2D.Double(vedge.getVisualVertexB().getBounds2D().getCenterX(), vedge.getVisualVertexB().getBounds2D().getCenterY());
        GeneralPath gPath = vedge.getGeneralPath();
        gPath.reset();
        gPath.moveTo((float)(fromcenter.x + fromport.x), (float)(fromcenter.y + fromport.y));
        if (((List)this.topedges.get(fromindex)).contains(vedge) || ((List)this.bottomedges.get(fromindex)).contains(vedge)) {
            gPath.lineTo((float)(fromcenter.x + fromport.x), (float)(tocenter.y + toport.y));
        } else if (((List)this.leftedges.get(fromindex)).contains(vedge) || ((List)this.rightedges.get(fromindex)).contains(vedge)) {
            gPath.lineTo((float)(tocenter.x + toport.x), (float)(fromcenter.y + fromport.y));
        }
        gPath.lineTo((float)(tocenter.x + toport.x), (float)(tocenter.y + toport.y));
    }

    protected void routeEdges() {
        int i;
        int size = this.vgraph.getVisualVertices().size();
        for (i = 0; i < size; ++i) {
            ((List)this.topedges.get(i)).clear();
            ((List)this.bottomedges.get(i)).clear();
            ((List)this.leftedges.get(i)).clear();
            ((List)this.rightedges.get(i)).clear();
        }
        size = this.vgraph.getVisualEdges().size();
        for (i = 0; i < size; ++i) {
            this.routeEdge((VisualEdge)this.vgraph.getVisualEdges().get(i));
        }
    }

    protected void routeEdge(VisualEdge vedge) {
        Rectangle frombounds = vedge.getVisualVertexA().getBounds();
        Rectangle tobounds = vedge.getVisualVertexB().getBounds();
        Point2D.Float fromcenter = new Point2D.Float(new Double(frombounds.getCenterX()).floatValue(), new Double(frombounds.getCenterY()).floatValue());
        Point2D.Float tocenter = new Point2D.Float(new Double(tobounds.getCenterX()).floatValue(), new Double(tobounds.getCenterY()).floatValue());
        Point fromgridpoint = this.grid.findVisualVertex(vedge.getVisualVertexA());
        Point togridpoint = this.grid.findVisualVertex(vedge.getVisualVertexB());
        double fromwidth = frombounds.getWidth();
        double fromheight = frombounds.getHeight();
        double towidth = tobounds.getWidth();
        double toheight = tobounds.getHeight();
        int fromindex = this.vgraph.getVisualVertices().indexOf(vedge.getVisualVertexA());
        int toindex = this.vgraph.getVisualVertices().indexOf(vedge.getVisualVertexB());
        GeneralPath gPath = vedge.getGeneralPath();
        if (fromgridpoint.x == togridpoint.x) {
            if (togridpoint.y < fromgridpoint.y) {
                vedge.setFromPortAssignment(new Point2DDouble(fromwidth / 2.0, 0.0));
                vedge.setToPortAssignment(new Point2DDouble(towidth / 2.0, toheight));
                ((List)this.topedges.get(fromindex)).add(vedge);
                ((List)this.bottomedges.get(toindex)).add(vedge);
            } else if (togridpoint.y > fromgridpoint.y) {
                vedge.setFromPortAssignment(new Point2DDouble(fromwidth / 2.0, fromheight));
                vedge.setToPortAssignment(new Point2DDouble(towidth / 2.0, 0.0));
                ((List)this.bottomedges.get(fromindex)).add(vedge);
                ((List)this.topedges.get(toindex)).add(vedge);
            }
            gPath.reset();
            gPath.moveTo(fromcenter.x, fromcenter.y);
            gPath.lineTo(fromcenter.x, tocenter.y);
        } else if (togridpoint.y == fromgridpoint.y) {
            if (togridpoint.x < fromgridpoint.x) {
                vedge.setFromPortAssignment(new Point2DDouble(0.0, fromheight / 2.0));
                vedge.setToPortAssignment(new Point2DDouble(towidth, toheight / 2.0));
                ((List)this.leftedges.get(fromindex)).add(vedge);
                ((List)this.rightedges.get(toindex)).add(vedge);
            } else if (togridpoint.x > fromgridpoint.x) {
                vedge.setFromPortAssignment(new Point2DDouble(fromwidth, fromheight / 2.0));
                vedge.setToPortAssignment(new Point2DDouble(0.0, toheight / 2.0));
                ((List)this.rightedges.get(fromindex)).add(vedge);
                ((List)this.leftedges.get(toindex)).add(vedge);
            }
            gPath.reset();
            gPath.moveTo(fromcenter.x, fromcenter.y);
            gPath.lineTo(tocenter.x, fromcenter.y);
        }
        if (togridpoint.x > fromgridpoint.x && togridpoint.y < fromgridpoint.y) {
            gPath.reset();
            gPath.moveTo(fromcenter.x, fromcenter.y);
            if (fromwidth - (double)((List)this.topedges.get(fromindex)).size() + toheight - (double)((List)this.leftedges.get(toindex)).size() >= fromheight - (double)((List)this.rightedges.get(fromindex)).size() + towidth - (double)((List)this.bottomedges.get(toindex)).size()) {
                vedge.setFromPortAssignment(new Point2DDouble(fromwidth / 2.0, 0.0));
                vedge.setToPortAssignment(new Point2DDouble(0.0, toheight / 2.0));
                ((List)this.topedges.get(fromindex)).add(vedge);
                ((List)this.leftedges.get(toindex)).add(vedge);
                gPath.lineTo(fromcenter.x, tocenter.y);
            } else {
                vedge.setFromPortAssignment(new Point2DDouble(fromwidth, fromheight / 2.0));
                vedge.setToPortAssignment(new Point2DDouble(towidth / 2.0, toheight));
                ((List)this.rightedges.get(fromindex)).add(vedge);
                ((List)this.bottomedges.get(toindex)).add(vedge);
                gPath.lineTo(tocenter.x, fromcenter.y);
            }
            gPath.lineTo(tocenter.x, tocenter.y);
        } else if (togridpoint.x > fromgridpoint.x && togridpoint.y > fromgridpoint.y) {
            gPath.reset();
            gPath.moveTo(fromcenter.x, fromcenter.y);
            if (fromwidth - (double)((List)this.bottomedges.get(fromindex)).size() + toheight - (double)((List)this.leftedges.get(toindex)).size() >= fromheight - (double)((List)this.rightedges.get(fromindex)).size() + towidth - (double)((List)this.topedges.get(toindex)).size()) {
                vedge.setFromPortAssignment(new Point2DDouble(fromwidth / 2.0, fromheight));
                vedge.setToPortAssignment(new Point2DDouble(0.0, toheight / 2.0));
                ((List)this.bottomedges.get(fromindex)).add(vedge);
                ((List)this.leftedges.get(toindex)).add(vedge);
                gPath.lineTo(fromcenter.x, tocenter.y);
            } else {
                vedge.setFromPortAssignment(new Point2DDouble(fromwidth, fromheight / 2.0));
                vedge.setToPortAssignment(new Point2DDouble(towidth / 2.0, 0.0));
                ((List)this.rightedges.get(fromindex)).add(vedge);
                ((List)this.topedges.get(toindex)).add(vedge);
                gPath.lineTo(tocenter.x, fromcenter.y);
            }
            gPath.lineTo(tocenter.x, tocenter.y);
        } else if (togridpoint.x < fromgridpoint.x && togridpoint.y > fromgridpoint.y) {
            gPath.reset();
            gPath.moveTo(fromcenter.x, fromcenter.y);
            if (fromwidth - (double)((List)this.bottomedges.get(fromindex)).size() + toheight - (double)((List)this.rightedges.get(toindex)).size() >= fromheight - (double)((List)this.leftedges.get(fromindex)).size() + towidth - (double)((List)this.topedges.get(toindex)).size()) {
                vedge.setFromPortAssignment(new Point2DDouble(fromwidth / 2.0, fromheight));
                vedge.setToPortAssignment(new Point2DDouble(towidth, toheight / 2.0));
                ((List)this.bottomedges.get(fromindex)).add(vedge);
                ((List)this.rightedges.get(toindex)).add(vedge);
                gPath.lineTo(fromcenter.x, tocenter.y);
            } else {
                vedge.setFromPortAssignment(new Point2DDouble(0.0, fromheight / 2.0));
                vedge.setToPortAssignment(new Point2DDouble(towidth / 2.0, 0.0));
                ((List)this.leftedges.get(fromindex)).add(vedge);
                ((List)this.topedges.get(toindex)).add(vedge);
                gPath.lineTo(tocenter.x, fromcenter.y);
            }
            gPath.lineTo(tocenter.x, tocenter.y);
        } else if (togridpoint.x < fromgridpoint.x && togridpoint.y < fromgridpoint.y) {
            gPath.reset();
            gPath.moveTo(fromcenter.x, fromcenter.y);
            if (fromwidth - (double)((List)this.topedges.get(fromindex)).size() + toheight - (double)((List)this.rightedges.get(toindex)).size() >= fromheight - (double)((List)this.leftedges.get(fromindex)).size() + towidth - (double)((List)this.bottomedges.get(toindex)).size()) {
                vedge.setFromPortAssignment(new Point2DDouble(fromwidth / 2.0, 0.0));
                vedge.setToPortAssignment(new Point2DDouble(towidth, toheight / 2.0));
                ((List)this.topedges.get(fromindex)).add(vedge);
                ((List)this.rightedges.get(toindex)).add(vedge);
                gPath.lineTo(fromcenter.x, tocenter.y);
            } else {
                vedge.setFromPortAssignment(new Point2DDouble(0.0, fromheight / 2.0));
                vedge.setToPortAssignment(new Point2DDouble(towidth / 2.0, toheight));
                ((List)this.leftedges.get(fromindex)).add(vedge);
                ((List)this.bottomedges.get(toindex)).add(vedge);
                gPath.lineTo(tocenter.x, fromcenter.y);
            }
            gPath.lineTo(tocenter.x, tocenter.y);
        }
    }

    private void portassignment() {
        int size = this.vgraph.getVisualVertices().size();
        for (int i = 0; i < size; ++i) {
            this.portassignment((VisualVertex)this.vgraph.getVisualVertices().get(i));
        }
    }

    private void portassignment(VisualVertex vvertex) {
        VisualEdge vedge;
        int i;
        Point2D.Double center = new Point2D.Double(vvertex.getBounds2D().getCenterX(), vvertex.getBounds2D().getCenterY());
        int index = this.vgraph.getVisualVertices().indexOf(vvertex);
        AffineTransform transform = new AffineTransform();
        Point2DDouble portpoint = new Point2DDouble();
        Point2DDouble translatedportpoint = new Point2DDouble();
        double[] segment = new double[6];
        transform.setToTranslation(vvertex.getBounds2D().getMinX() - vvertex.getBounds2D().getCenterX(), vvertex.getBounds2D().getMinY() - vvertex.getBounds2D().getCenterY());
        double width = vvertex.getBounds2D().getWidth();
        double height = vvertex.getBounds2D().getHeight();
        int size = ((List)this.topedges.get(index)).size();
        for (i = 0; i < size; ++i) {
            vedge = (VisualEdge)((List)this.topedges.get(index)).get(i);
            portpoint.x = (double)(i + 1) * width / (double)(size + 1);
            portpoint.y = 0.0;
            transform.transform(portpoint, translatedportpoint);
            if (vedge.getVisualVertexA() == vvertex) {
                vedge.setFromPortAssignment(translatedportpoint);
                continue;
            }
            vedge.setToPortAssignment(translatedportpoint);
        }
        size = ((List)this.leftedges.get(index)).size();
        for (i = 0; i < size; ++i) {
            vedge = (VisualEdge)((List)this.leftedges.get(index)).get(i);
            portpoint.x = 0.0;
            portpoint.y = (double)(size - i) * height / (double)(size + 1);
            transform.transform(portpoint, translatedportpoint);
            if (vedge.getVisualVertexA() == vvertex) {
                vedge.setFromPortAssignment(translatedportpoint);
                continue;
            }
            vedge.setToPortAssignment(translatedportpoint);
        }
        size = ((List)this.rightedges.get(index)).size();
        for (i = 0; i < size; ++i) {
            vedge = (VisualEdge)((List)this.rightedges.get(index)).get(i);
            portpoint.x = width;
            portpoint.y = (double)(i + 1) * height / (double)(size + 1);
            transform.transform(portpoint, translatedportpoint);
            if (vedge.getVisualVertexA() == vvertex) {
                vedge.setFromPortAssignment(translatedportpoint);
                continue;
            }
            vedge.setToPortAssignment(translatedportpoint);
        }
        size = ((List)this.bottomedges.get(index)).size();
        for (i = 0; i < size; ++i) {
            vedge = (VisualEdge)((List)this.bottomedges.get(index)).get(i);
            portpoint.x = (double)(size - i) * width / (double)(size + 1);
            portpoint.y = height;
            transform.transform(portpoint, translatedportpoint);
            if (vedge.getVisualVertexA() == vvertex) {
                vedge.setFromPortAssignment(translatedportpoint);
                continue;
            }
            vedge.setToPortAssignment(translatedportpoint);
        }
    }

    public void layout() {
        super.layout();
        this.initialized = true;
        this.initGraphLayout();
        this.generalPosition(this.vgraph.getVisualVertices(), this.grid);
        this.medianPlacement();
        this.routeEdges();
        this.portassignment();
        this.drawLayout();
    }
}

