% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifesto.R
\name{mp_metadata}
\alias{mp_metadata}
\title{Get meta data for election programmes}
\usage{
mp_metadata(ids, apikey = NULL, cache = TRUE)
}
\arguments{
\item{ids}{list of partys (as ids) and dates of elections, paired. Dates must
    be given either in the \code{date} or the \code{edate} variable,
    formatted in the way they are in the main data set in this package
    (date: as.numeric, YYYYMM, edate: as.Date()), see \code{\link{mp_maindataset}}
Alternatively, ids can be a logical expression specifying a subset of
the Manifesto Project's main dataset. It will be evaluated within the
data.frame returned by \code{\link{mp_maindataset}} such that all its
variables and functions thereof can be used in the expression.}

\item{apikey}{API key to use. Defaults to \code{NULL}, resulting in using
the API key set via \code{\link{mp_setapikey}}.}

\item{cache}{Boolean flag indicating whether to use locally cached data if
available.}
}
\value{
an object of class \code{ManifestoMetadata}, subclassing \code{data.frame}
        as well as \code{\link[dplyr]{tbl_df}} and containing the requested
        metadata in rows per election programme
}
\description{
Get meta data for election programmes
}
\details{
Meta data contain information on the available documents for a given party
and election date. This information comprises links to the text as well as
original documents if available, language, versions checksums and more.
}
\examples{
\dontrun{
mp_metadata(party == 21221)

wanted <- data.frame(party=c(41320, 41320), date=c(200909, 200509))
mp_metadata(wanted)
}
}

