% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_mean_na.R
\name{row_mean_na}
\alias{row_mean_na}
\title{Replacing all NAs with mean values of a given row}
\usage{
row_mean_na(data, func, observations, na.rm = F, exc)
}
\arguments{
\item{data}{is the data you for which the mean is needed}

\item{func}{describes the function to use. Currrently only supports the mean(others may work with some inaccuracies)}

\item{observations}{takes on column names  for which manipulations are required}

\item{na.rm}{Logical. Should NAs be removed from analysis?}

\item{exc}{the column to exclude from analysis. Useful for removing factor columns}
}
\value{
Returns a data.frame object showing columns with NAs and their replacement if na.rm=T
}
\description{
Replacing all NAs with mean values of a given row
}
\examples{
#This merges our replacement values with the original data containing NAs
row_mean_na(airquality,mean,c("Ozone","Wind"),na.rm=TRUE,0)
\dontrun{
row_mean_na(iris,max,c("Sepal.Length","Petal.Length"),na.rm = F,5)
}
}
