% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_corr.R
\name{plot_corr}
\alias{plot_corr}
\title{Plot a correlations matrix}
\usage{
plot_corr(
  df,
  x = "Comparison_Var",
  y = "Other_Var",
  xlabel = "Comparison_Variable",
  ylabel = "Other_Variable",
  title = "Correlations Plot",
  plot_style = "circles",
  title_just = 0.5,
  round_values = TRUE,
  round_which = "Correlation",
  colour_by = "Correlation",
  decimals = 2,
  show_which = "corr",
  size = 12.6,
  value_angle = 360,
  shape = 16,
  value_size = 3.5,
  value_col = "black",
  width = 1.1,
  custom_cols = c("indianred2", "green2", "gray34"),
  legend_labels = waiver(),
  legend_title = NULL,
  signif_cutoff = 0.05,
  signif_size = 7,
  signif_col = "gray13",
  ...
)
}
\arguments{
\item{df}{The data to be plotted. A `data.frame` object produced
by `get_var_corr_`}

\item{x}{Value for the x axis. Defaults to "Comparison_Var"}

\item{y}{Values for the y axis. Defaults to "Other_Var."}

\item{xlabel}{label for the x axis}

\item{ylabel}{label for the y axis}

\item{title}{plot title.}

\item{plot_style}{One of squares and circles(currently).}

\item{title_just}{Justification of the title. Defaults to 0.5, title is centered.}

\item{round_values}{Logical. Should values be rounded off? Defaults to TRUE.}

\item{round_which}{Character. The column name to be rounded off.}

\item{colour_by}{The column to use for coloring. Defaults to  "Correlation". Colour strength thus
indicates the strength of correlations.}

\item{decimals}{Numeric. To how many decimal places should the rounding be done?
Defaults to 2.}

\item{show_which}{Character. One of either corr or signif to control whether to show the
correlation values or significance stars of the correlations. This is case sensitive and defaults to
corr ie correlation values are shown.}

\item{size}{Size of the circles for plot_style set to circles}

\item{value_angle}{What angle should the text be?}

\item{shape}{Values for the shape if plot_style is circles}

\item{value_size}{Size of the text.}

\item{value_col}{What colour should the text in the squares/circles be?}

\item{width}{width value for plot_style set to squares.}

\item{custom_cols}{A vector(length 2) of colors to use for the plot. The first colour specifies the lower end of the
correlations. The second specifies  the higher end.}

\item{legend_labels}{Text to use for the legend labels. Defaults to the default
labels produced by the plot method.}

\item{legend_title}{Title to use for the legend.}

\item{signif_cutoff}{Numeric. If show_signif is TRUE, this defines the cutoff point for significance. Defaults to 
0.05.}

\item{signif_size}{Numeric. Defines size of the significance stars.}

\item{signif_col}{Charcater. Defines the col for the significance stars.}

\item{...}{Other arguments to specific methods(`geom_text`) Useful once `show_signif` is set to  TRUE.}
}
\value{
A `ggplot2` object showing the correlations plot.
}
\description{
This function plots the results produced by
`get_var_corr_`.
}
\details{
This function uses `ggplot2` backend. `ggplot2` is thus required for the plots to work.
Since the correlations are obtained by `get_var_corr_`, the default is to omit correlation between a variable and itself. Therefore
blanks in the plot would indicate a correlation of 1.
}
\examples{
# compute correlations
res<-get_var_corr_(mtcars)
# defaults
plot_corr(res,show_which = "corr",
round_values = TRUE,
round_which = "Correlation",decimals = 2,x="Other_Var", 
y="Comparison_Var",plot_style = "circles",width = 1.1,
custom_cols = c("green","blue","red"),colour_by = "Correlation")
}
