% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_scatterplot.R
\name{add_scatterplot}
\alias{add_scatterplot}
\title{Add Scatterplot}
\usage{
add_scatterplot(map, data = get_map_data(map), lon = NULL, lat = NULL,
  polyline = NULL, radius = NULL, fill_colour = NULL,
  fill_opacity = NULL, layer_id, digits = 6,
  palette = viridisLite::viridis)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer}

\item{lon}{column containing longitude values}

\item{lat}{column containing latitude values}

\item{polyline}{column of \code{data} containing the polylines}

\item{radius}{in metres}

\item{fill_colour}{column of \code{data} or hex colour for the fill colour}

\item{fill_opacity}{value between 1 and 255. Either a string specifying the
column of \code{data} containing the fill opacity of each shape, or a value
between 1 and 255 to be applied to all the shapes}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}

\item{palette}{a function which generates hex colours}
}
\description{
The Scatterplot Layer takes in coordinate points and renders them as circles
with a certain radius.
}
\examples{

\donttest{
## You need a valid access token from Mapbox
key <- 'abc'

mapdeck( token = key, style = 'mapbox://styles/mapbox/dark-v9', pitch = 45 ) \%>\%
add_scatterplot(
  data = capitals
  , lat = "lat"
  , lon = "lon"
  , radius = 100000
  , fill_colour = "country"
  , layer_id = "scatter_layer"
)

df <- read.csv(paste0(
'https://raw.githubusercontent.com/uber-common/deck.gl-data/master/',
'examples/3d-heatmap/heatmap-data.csv'
))

mapdeck( token = key, style = 'mapbox://styles/mapbox/dark-v9', pitch = 45 ) \%>\%
add_scatterplot(
  data = df
  , lat = "lat"
  , lon = "lng"
  , layer_id = "scatter_layer"
)
}

}
