% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_drought_indicator.R
\docType{data}
\name{drought_indicator}
\alias{drought_indicator}
\title{Calculate drought indicator statistics}
\format{
A tibble with a column for each specified stats and a column with the respective date.
}
\description{
This function allows to efficiently calculate the relative wetness in the
shallow groundwater section with regard to the the 1948-2012 reference period.
The values represent the wetness percentile a given area achieves at a given
point in time in regard to the reference period.
For each polygon, the desired statistic/s (mean, median or sd) is/are
returned. The required resources for this indicator are:
\itemize{
\item \link{nasagrace}
}
}
\details{
The following arguments can be set:
\describe{
\item{stats_drought}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character "mean", "median" or "sd".}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
library(sf)
library(mapme.biodiversity)

temp_loc <- file.path(tempdir(), "mapme.biodiversity")
if(!file.exists(temp_loc)){
dir.create(temp_loc)
resource_dir <- system.file("res", package = "mapme.biodiversity")
file.copy(resource_dir, temp_loc, recursive = TRUE)
}

(try(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
                        package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2022,
    outdir = file.path(temp_loc, "res"),
    tmpdir = tempdir(),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources("nasagrace") \%>\%
  calc_indicators("drought_indicator", stats_drought = c("mean", "median"), engine = "extract") \%>\%
  tidyr::unnest(drought_indicator)))
}
\keyword{indicator}
