% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_treecover_area.R
\docType{data}
\name{treecover_area}
\alias{treecover_area}
\title{Calculate treecover statistics}
\format{
A tibble with a column for years and treecover (in ha)
}
\description{
This functions allows to efficiently calculate treecover statistics for
polygons. For each year in the analysis timeframe, the forest losses in
preceding and the current years are subtracted from the treecover in the
year 2000 and actual treecover figures within the polygon are returned.
The required resources for this indicator are:
\itemize{
\item \link{gfw_treecover}
\item \link{gfw_lossyear}
}
}
\details{
The following arguments can be set:
\describe{
\item{min_size}{The minimum size of a forest patch to be considered as forest in ha.}
\item{min_cover}{The minimum cover percentage per pixel to be considered as forest.}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2016:2017,
    outdir = outdir,
    tmpdir = tempdir(),
    add_resources = FALSE,
    verbose = FALSE
  ) \%>\%
  get_resources(
    resources = c("gfw_treecover", "gfw_lossyear"),
    vers_treecover = "GFC-2021-v1.9", vers_lossyear = "GFC-2021-v1.9"
  ) \%>\%
  calc_indicators("treecover_area", min_size = 1, min_cover = 30) \%>\%
  tidyr::unnest(treecover_area)

aoi
}
}
\keyword{indicator}
