% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gsw_occurrence.R
\name{gsw_occurrence}
\alias{gsw_occurrence}
\alias{calc_gsw_occurrence}
\title{Calculate Global Surface Water (GSW) Occurrence}
\usage{
calc_gsw_occurrence(engine = "extract", min_occurrence = NULL)
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract". Default: "extract".}

\item{min_occurrence}{Threshold to define which pixels count towards the GSW
occurrence area \verb{[0, 100]}.}
}
\value{
A function that returns a tibble with a column for the aggregated
GSW occurrence indicator.
}
\description{
GSW occurrence raw data comes in raster files with integer cell values
between \verb{[0, 100]}. This value gives the percentage of the time that a
given pixel was classified as water during the entire observation period. So
a 0 denotes a pixel that was never classified as water, 100 denotes a pixel
with permanent water.
}
\details{
The raw data values are aggregated based on a provided threshold parameter
\code{min_occurrence}, the function returns the area covered by values
greater or equal than this threshold.

The required resources for this indicator are:
\itemize{
\item \link{global_surface_water_occurrence}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_global_surface_water_occurrence()) \%>\%
  calc_indicators(
    calc_gsw_occurrence(engine = "extract", min_occurrence = 10)
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
