% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gsw_time_series.R
\name{gsw_time_series_resource}
\alias{gsw_time_series_resource}
\alias{get_gsw_time_series}
\title{Helper function to download Global Surface Water (GSW) yearly time series
data}
\source{
Raw Data: \url{https://jeodpp.jrc.ec.europa.eu/ftp/jrc-opendata/GSWE/YearlyClassification/LATEST/tiles/}
}
\usage{
get_gsw_time_series(years, version = "LATEST")
}
\arguments{
\item{years}{Numeric vector of years to process between 1984 and 2021.
Default: \code{1984:2021}.}

\item{version}{Version of the data set to process. Available options are
(\code{VER1-0}, \code{VER2-0}, \code{VER3-0}, \code{VER4-0}, \code{VER5-0} and \code{LATEST}) Default:
\code{LATEST}. Choosing \code{LATEST} will result in the latest available version.}
}
\value{
A function that returns a character vector of file paths.
}
\description{
This function constructs  the necessary data URLs for a given data set,
version and polygon and downloads them for further processing with the
mapme.biodiversity package.
}
\details{
The available surface water classes for a given pixel are the following:
\itemize{
\item No Observation: It was not possible to determine whether a pixel was water
(this may be the case for frozen areas or during the polar night in extreme
latitudes).
\item Permanent Water: Water was detected in twelve months per year or in a
combination of permanent and no observation.
\item Seasonal Water: Water and no water was detected.
\item No Water: No Water was detected.
}
}
\references{
\itemize{
\item Global Surface Water Explorer: \url{https://global-surface-water.appspot.com/}
\item Data Users Guide: \url{https://storage.cloud.google.com/global-surface-water/downloads_ancillary/DataUsersGuidev2021.pdf}
\item Research Article: \url{https://www.nature.com/articles/nature20584}
}
}
\keyword{resource}
