% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map_list.R
\name{plot_map_list}
\alias{plot_map_list}
\title{Plot a genetic map}
\usage{
plot_map_list(
  map.list,
  horiz = TRUE,
  col = "lightgray",
  title = "Linkage group"
)
}
\arguments{
\item{map.list}{A list of objects or a single object of class \code{mappoly.map}}

\item{horiz}{logical. If FALSE, the maps are plotted vertically with the first map to the left. 
If TRUE  (default), the maps are plotted horizontally with the first at the bottom}

\item{col}{a vector of colors for each linkage group.  (default = 'lightgray')
\code{ggstyle} produces maps using the default \code{ggplot} color palette.}

\item{title}{a title (string) for the maps (default = 'Linkage group')}
}
\value{
A \code{data.frame} object containing the name of the markers and their genetic position
}
\description{
This function plots a genetic linkage map(s) generated by \code{MAPpoly}.
The map(s) should be passed as a single object or a list of objects of class \code{mappoly.map}.
}
\examples{
 ## hexafake map
 plot_map_list(maps.hexafake, horiz = FALSE)
 plot_map_list(maps.hexafake, col = c("#999999", "#E69F00", "#56B4E9"))
 
 ## solcap map
 plot_map_list(solcap.dose.map, col = "ggstyle")
 plot_map_list(solcap.dose.map, col = "mp_pallet3", horiz = FALSE)
 
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
