% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_directions.R
\name{google_directions}
\alias{google_directions}
\title{Get directions from the Google Maps Directions API}
\usage{
google_directions(origin, destination, mode = c("driving", "transit",
  "walking", "bicycling"), alternatives = FALSE, avoid = NULL, key = NULL)
}
\arguments{
\item{origin}{Origin, as \itemize{
\item{\code{character} vector of length one with address to be geocoded}
\item{\code{numeric} vector of length two (lon, lat)}
\item{\code{matrix} with one row and two columns (lon, lat)}
\item{\code{sf} or \code{sfc} layer with one feature}
}}

\item{destination}{Destination, as numeric vector of length two (lon, lat)}

\item{mode}{Travel mode, one of: \code{"driving"} (default), \code{"transit"}, \code{"walking"}, \code{"bicycling"}}

\item{alternatives}{Whether to return more than one alternative (\code{logical})}

\item{avoid}{\code{NULL} (default) or one of: \code{"tolls"}, \code{"highways"}, \code{"ferries"}}

\item{key}{Google APIs key (optional)}
}
\value{
XML document with Google Maps Directions API response
}
\description{
Get directions from the Google Maps Directions API
}
\examples{
library(xml2)
doc = as_xml_document(response_directions)
\dontrun{
doc = google_directions(
  origin = c(34.81127, 31.89277),
  destination = c(34.781107, 32.085003),
  alternatives = TRUE
)
doc = google_directions(
  origin = "Beer-Sheva",
  destination = c(34.781107, 32.085003) \%>\% st_point \%>\% st_sfc(crs = 4326),
  alternatives = TRUE
)
}
}
