% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_grad.R
\name{mf_grad}
\alias{mf_grad}
\title{Plot graduated symbols}
\usage{
mf_grad(
  x,
  var,
  breaks = "quantile",
  nbreaks = 3,
  col = "tomato4",
  border,
  pch = 21,
  cex,
  lwd,
  leg_pos = mf_get_leg_pos(x),
  leg_title = var,
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_val_rnd = 2,
  leg_frame = FALSE,
  add = TRUE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{breaks}{either a numeric vector with the actual breaks, or a classification method name (see \link{mf_get_breaks})}

\item{nbreaks}{number of classes}

\item{col}{color}

\item{border}{border color}

\item{pch}{pch for symbols}

\item{cex}{cex for symbols}

\item{lwd}{border width}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos is 'n' then the legend is not plotted.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
x is (invisibly) returned.
}
\description{
Plot graduated symbols based on quantitative data.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_grad(mtq, "POP", pch = 22)
}
\keyword{internal}
