% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_averages.R
\name{get_averages}
\alias{get_averages}
\title{Average Estimates (aka "Margins")}
\usage{
get_averages(x, by = TRUE, ...)
}
\arguments{
\item{x}{Object produced by the \code{predictions()}, \code{comparisons()}, or \code{slopes()} functions.}

\item{by}{Character vector of variable names over which to compute group-wise average estimates. When \code{by=NULL}, the global average (per term) is reported.}

\item{...}{All additional arguments are passed to the original fitting
function to override the original call options: \code{conf_level}, \code{transform},
etc. See \code{?predictions}, \code{?comparisons}, \code{?slopes}.}
}
\value{
A \code{data.frame} of estimates and uncertainty estimates
}
\description{
Calculate average estimates by taking the (group-wise) mean of all the unit-level
estimates computed by the \code{predictions()}, \code{comparisons()}, or \code{slopes()} functions.

Warning: It is generally faster and safer to use the \code{by} argument of one of
the three functions listed above. Alternatively, one can call it in one step:

\code{avg_slopes(model)}

\code{slopes(model, by = TRUE)}

Proceeding in two steps by assigning the unit-level estimates is typically
slower, because all estimates must be computed twice.

Note that the \code{tidy()} and \code{summary()} methods are slower wrappers around \verb{avg_*()} functions.
}
\details{
Standard errors are estimated using the delta method. See the \code{marginaleffects} website for details.

In Bayesian models (e.g., \code{brms}), estimates are aggregated applying the
median (or mean) function twice. First, we apply it to all
marginal effects for each posterior draw, thereby estimating one Average (or
Median) Marginal Effect per iteration of the MCMC chain. Second, we
calculate the mean and the \code{quantile} function to the results of Step 1 to
obtain the Average Marginal Effect and its associated interval.
}
\examples{
mod <- lm(mpg ~ factor(gear), data = mtcars)
contr <- comparisons(mod, variables = list(gear = "sequential"))
tidy(contr)
}
\keyword{internal}
