% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanMaxLength.R
\name{meanMaxLength}
\alias{meanMaxLength}
\title{Calculates the Mean Maximum Length of fish in the community}
\usage{
meanMaxLength(X, group, species.table = NULL, maxlength.table, metric,
  years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{BIOMASS}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{BIOMASS} is the corresponding biomass (stratified
and corrected for catchability as required).}

\item{group}{character string indicating which species to include in the
indicator calculation. If \code{group = "ALL"}, all species will be
included; otherwise, \code{group} should match a column name in
\code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{maxlength.table}{A dataframe with columns \code{SPECIES} and
\code{MAXLENGTH}, the maximum recorded length of the corresponding species.
Entries in the \code{SPECIES} column should be the unique values of species
codes in \code{X} (or a subset thereof). Other columns in
\code{maxlength.table} are ignored.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate indicator. Default is \code{metric = "BIOMASS"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with 3 columns. \code{ID}, \code{YEAR}, and
 \code{MMLength_metric}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 value is assigned \code{NA}.
}
\description{
This function calculates the Mean Maximum Length of fish in the
 community weighted by biomass or abundance for \eqn{j} areas and \eqn{i}
 years.
}
\details{
Mean Maximum Length: \deqn{Mean Maximum Length = \Sigma
 (L_{max,i}*M_i)/\Sigma M_i} where \eqn{L_{max,i}} is the maximum asymptotic
 length (cm) of species \eqn{i}, and \eqn{M_i} is biomass or abundance of
 species \eqn{i} (excluding invertebrates; Shin et al., 2005).
}
\examples{
# Compile data
data(X)
data(species.info)
data(species.table)

# Calculate indicators
# Weighted by abundance
meanMaxLength(X, group = "FINFISH", species.table = species.table, 
   maxlength.table = species.info, metric = "ABUNDANCE", years = c(2014:2019))
#Weighted by biomass
meanMaxLength(X, group = "FINFISH", species.table = species.table, 
   maxlength.table = species.info, metric = "BIOMASS", years = c(2014:2019))

}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Shin YJ, Rochet MJ, Jennings S, Field JG, Gislason H. 2005. Using size-based
 indicators to evaluate the ecosystem effects of fishing. In: ICES Journal of
 Marine Science. p 384-396
}
\seealso{
Other stability and resistance indicators: \code{\link{CVBiomass}},
  \code{\link{IVILandings}}, \code{\link{allStability}},
  \code{\link{biomassPerTL}}, \code{\link{meanMaxAge}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{stability and resistance indicators}
