% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{median2}
\alias{median2}
\alias{q50}
\title{Median (Q 50)}
\usage{
median2(x, type = 7, na.rm = FALSE)

q50(x, type = 7, na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector whose sample quantiles are wanted, or an
    object of a class for which a method has been defined (see also
    \sQuote{details}). \code{\link{NA}} and \code{NaN} values are not
    allowed in numeric vectors unless \code{na.rm} is \code{TRUE}.}

\item{type}{an integer between 1 and 9 selecting one of the
    nine quantile algorithms detailed below to be used.}

\item{na.rm}{logical; if true, any \code{\link{NA}} and \code{NaN}'s
    are removed from \code{x} before the quantiles are computed.}
}
\value{
See \code{stats::quantile()}
}
\description{
Median as the 50th quantile with an option to select quantile algorithm
}
\details{
\code{q50} is an alias for \code{median2}
}
\examples{
set.seed(42)
x <- rnorm(100)
median(x)            # 0.08979677
median2(x, type = 7) # 0.08979677 - default type is 7
median2(x, type = 3) # 0.08976065

}
\seealso{
\code{\link[stats:quantile]{stats::quantile()}}
}
