% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mb_bet_cancel.R
\name{mb_bet_cancel}
\alias{mb_bet_cancel}
\title{Perform a Bet Cancel Action}
\usage{
mb_bet_cancel(session_data, bet_id = NULL, event_id = NULL,
  market_id = NULL, runner_id = NULL, cancel_all = FALSE)
}
\arguments{
\item{session_data}{A session object returned from a successful mb_login attempt. It contains details about your user preferences and security details.}

\item{bet_id}{The bet_id or vector of bet_ids that you want to cancel.}

\item{event_id}{The event_id or vector of event_ids that you want to cancel.}

\item{market_id}{The market_id or vector of market_ids that you want to cancel.}

\item{runner_id}{The runner_id or vector of runner_ids that you want to cancel.}

\item{cancel_all}{Boolean variable. Parameter to allow cancellation of all bets on all events/markets/runners. Default is FALSE.}
}
\value{
The status and details of your bet cancellations are returned.
The data frame has the following fields:
 \describe{
  \item{id}{the bet id}
  \item{event-id}{the event id on which the original bet was placed}
  \item{event-name}{the name of the event on which the original bet was placed}
  \item{event-id}{the event id on which the original bet was placed}
  \item{market-id}{the market id on which the original bet was placed}
  \item{market-name}{the name of the market on which the original bet was placed}
  \item{runner-id}{the runner id on which the original bet was placed}
  \item{runner-name}{the name of the runner on which the original bet was placed}
  \item{temp-id}{the temporary id of the update}
  \item{exchange-type}{the exchange type. This should always be 'back-lay'}
  \item{side}{the side the bet was placed on}
  \item{odds}{the odds the bet was placed on}
  \item{odds-type}{the odds-type of the odds field }
  \item{decimal-odds}{the decimal version of the odds}
  \item{stake}{the stake placed}
  \item{potential-profit}{the potential profit if the matched component of this wager is successful}   
  \item{remaining-potential-profit}{the potential profit if the un-matched component of this wager is first matched and then has a successful outcome}   
  \item{currency}{The currency the bet stake was placed with}   
  \item{created-at}{The date the bet was placed}   
  \item{status}{The bet status. Status 'open' indicates an unmatched bet, 'matched' indicates a fully matched bet, 'cancelled' indicates a cancelled bet. For bets with status='open', the 'stake' and 'remaining' fields are key to determining the exact status. If the 'remaining' value is less than 'stake' but greater than zero, then the bet has been partially matched for a 'stake'-'remaining' amount. If the bet is fully un-matched, then the 'stake' and 'remaining' values will be equal.}   
}
If no bets have been cancelled the 'offers' object will be an empty list.
}
\description{
This function provides bet cancellation functionality. It is possible to cancel a single bet by entering in a single value for the bet_id parameter. It is also possible to cancel multiple bets at once by passing a vector of the bet_id parameter. It is also possible to cancel all bets from a given market, event or runner by entering the corresponding ids. NOTE: bets with status 'matched' or 'revised' can not be cancelled.
}
\examples{
\dontrun{my_session <- mb_login("my_user_name","verysafepassword"); 
mb_bet_cancel(session_data=my_session,odds=2.5,stake=5,runner_id=12345)}

}
\seealso{
\code{\link{mb_get_bets},\link{mb_bet_place},\link{mb_bet_update}}
}

