/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.real;

import choco.cp.solver.variables.real.RealDomainImpl;
import choco.cp.solver.variables.real.RealVarEvent;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.structure.Couple;
import choco.kernel.memory.structure.PartiallyStoredRealCstrList;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.real.RealDomain;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealMath;
import choco.kernel.solver.variables.real.RealVar;
import java.util.List;
import java.util.Set;

public final class RealVarImpl<C extends AbstractSConstraint>
extends AbstractVar
implements RealVar {
    protected RealDomain domain;
    private final Solver solver;

    public <C extends AbstractSConstraint> RealVarImpl(Solver solver, String name, double a, double b, int domaintype) {
        super(solver, name, new PartiallyStoredRealCstrList(solver.getEnvironment()));
        if (domaintype != 0) {
            throw new SolverException("Unknown real domain");
        }
        this.domain = new RealDomainImpl(this, a, b, solver);
        this.event = new RealVarEvent(this);
        this.solver = solver;
    }

    public final DisposableIterator<Couple<C>> getActiveConstraints(C cstrCause) {
        return ((PartiallyStoredRealCstrList)this.constraints).getActiveConstraint(cstrCause);
    }

    @Override
    public String toString() {
        return this.name + this.domain.toString();
    }

    @Override
    public String pretty() {
        return this.toString();
    }

    @Override
    public RealInterval getValue() {
        return new RealIntervalConstant(this.getInf(), this.getSup());
    }

    @Override
    public RealDomain getDomain() {
        return this.domain;
    }

    @Override
    public void silentlyAssign(RealInterval i) {
        this.domain.silentlyAssign(i);
    }

    @Override
    public double getInf() {
        return this.domain.getInf();
    }

    @Override
    public double getSup() {
        return this.domain.getSup();
    }

    @Override
    public void intersect(RealInterval interval) throws ContradictionException {
        this.domain.intersect(interval);
    }

    @Override
    public boolean isInstantiated() {
        return RealMath.isCanonical(this, this.solver.getPrecision());
    }

    @Override
    public void tighten() {
    }

    @Override
    public void project() {
    }

    @Override
    public List<RealExp> subExps(List<RealExp> l) {
        l.add(this);
        return l;
    }

    @Override
    public Set<RealVar> collectVars(Set<RealVar> s) {
        s.add(this);
        return s;
    }

    @Override
    public boolean isolate(RealVar var, List<RealExp> wx, List<RealExp> wox) {
        return this == var;
    }
}

