/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.integer;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.DistanceXYC;
import choco.cp.solver.constraints.integer.DistanceXYZ;
import choco.kernel.model.ModelException;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.List;

public final class DistanceManager
extends IntConstraintManager {
    private static final int NEQ = 3;

    public SConstraint makeConstraint(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver && parameters instanceof Integer) {
            int type = (Integer)parameters;
            if (variables.length == 3) {
                return new DistanceXYC(solver.getVar(variables[0]), solver.getVar(variables[1]), ((IntegerConstantVariable)variables[2]).getValue(), type);
            }
            if (type != 3) {
                return new DistanceXYZ(solver.getVar(variables[0]), solver.getVar(variables[1]), solver.getVar(variables[2]), ((IntegerConstantVariable)variables[3]).getValue(), type);
            }
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }

    @Override
    public SConstraint[] makeConstraintAndOpposite(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        SConstraint[] cs = new SConstraint[2];
        if (solver instanceof CPSolver && parameters instanceof Integer) {
            int type = (Integer)parameters;
            if (variables.length == 3) {
                return super.makeConstraintAndOpposite(solver, variables, parameters, options);
            }
            IntDomainVar X = solver.getVar(variables[2]);
            IntDomainVar Y = X.hasBooleanDomain() ? solver.createBooleanVar("Y_opp") : (X.hasEnumeratedDomain() ? solver.createEnumIntVar("Y_opp", X.getInf(), X.getSup()) : solver.createBoundIntVar("Y_opp", X.getInf(), X.getSup()));
            if (type != 3) {
                solver.post(new DistanceXYZ(solver.getVar(variables[0]), solver.getVar(variables[1]), Y, ((IntegerConstantVariable)variables[3]).getValue(), type));
            }
            cs[0] = solver.eq((IntExp)Y, (IntExp)X);
            cs[1] = solver.neq((IntExp)Y, (IntExp)X);
            return cs;
        }
        throw new ModelException("Could not found a constraint and opposite manager in " + this.getClass() + " !");
    }
}

