/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class EqualXY_C
extends AbstractBinIntSConstraint {
    protected final int cste;
    private DisposableIntIterator reuseIter;

    public EqualXY_C(IntDomainVar x0, IntDomainVar x1, int c) {
        super(x0, x1);
        this.cste = c;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v1.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    private final void updateInfV0() throws ContradictionException {
        this.v0.updateInf(this.cste - this.v1.getSup(), this, false);
    }

    private final void updateInfV1() throws ContradictionException {
        this.v1.updateInf(this.cste - this.v0.getSup(), this, false);
    }

    private final void updateSupV0() throws ContradictionException {
        this.v0.updateSup(this.cste - this.v1.getInf(), this, false);
    }

    private final void updateSupV1() throws ContradictionException {
        this.v1.updateSup(this.cste - this.v0.getInf(), this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate() throws ContradictionException {
        this.updateInfV0();
        this.updateSupV0();
        this.updateInfV1();
        this.updateSupV1();
        this.reuseIter = this.v0.getDomain().getIterator();
        if (this.v1.hasEnumeratedDomain() && this.v0.hasEnumeratedDomain()) {
            int val;
            try {
                while (this.reuseIter.hasNext()) {
                    val = this.reuseIter.next();
                    if (this.v1.canBeInstantiatedTo(this.cste - val)) continue;
                    this.v0.removeVal(val, this, false);
                }
            }
            finally {
                this.reuseIter.dispose();
            }
            this.reuseIter = this.v1.getDomain().getIterator();
            try {
                while (this.reuseIter.hasNext()) {
                    val = this.reuseIter.next();
                    if (this.v0.canBeInstantiatedTo(this.cste - val)) continue;
                    this.v1.removeVal(val, this, false);
                }
            }
            finally {
                this.reuseIter.dispose();
            }
        }
    }

    @Override
    public final void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            this.updateSupV1();
        } else {
            this.updateSupV0();
        }
    }

    @Override
    public final void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.updateInfV1();
        } else {
            this.updateInfV0();
        }
    }

    @Override
    public final void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            this.v1.instantiate(this.cste - this.v0.getVal(), this, false);
        } else {
            this.v0.instantiate(this.cste - this.v1.getVal(), this, false);
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx == 0) {
            this.v1.removeVal(this.cste - x, this, false);
        } else {
            this.v0.removeVal(this.cste - x, this, false);
        }
    }

    @Override
    public final Boolean isEntailed() {
        if (this.v0.getSup() + this.v1.getSup() < this.cste || this.v0.getInf() + this.v1.getInf() > this.cste) {
            return Boolean.FALSE;
        }
        if (this.v0.isInstantiated() && this.v1.isInstantiated() && this.v0.getVal() == this.v1.getVal() + this.cste) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public final boolean isSatisfied(int[] tuple) {
        return tuple[0] + tuple[1] == this.cste;
    }

    @Override
    public final boolean isConsistent() {
        return this.v0.getInf() + this.v1.getSup() == this.cste && this.v0.getSup() + this.v1.getInf() == this.cste;
    }

    @Override
    public final AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return (AbstractSConstraint)solver.neq(solver.plus((IntExp)this.v0, (IntExp)this.v1), this.cste);
    }

    @Override
    public final String pretty() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.v0.toString());
        sb.append(" + ");
        sb.append(this.v1.toString());
        sb.append(" = ");
        sb.append(this.cste);
        return sb.toString();
    }
}

