/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.configure;

import choco.kernel.solver.Configuration;
import choco.kernel.solver.ResolutionPolicy;
import choco.kernel.solver.Solver;
import choco.kernel.solver.search.limit.Limit;

public final class MessageFactory {
    private MessageFactory() {
    }

    public static String getGeneralMsg(Configuration conf, String problemName, String instanceName) {
        StringBuilder b = new StringBuilder(128);
        ResolutionPolicy policy = (ResolutionPolicy)((Object)conf.readEnum("cp.resolution.policy", ResolutionPolicy.class));
        switch (policy) {
            case MAXIMIZE: {
                b.append("MAXIMIZE    ");
                break;
            }
            case MINIMIZE: {
                b.append("MINIMIZE    ");
                break;
            }
            default: {
                b.append("CSP    ");
            }
        }
        if (conf.readBoolean("cp.resolution.stop_at_first_solution")) {
            b.append("FIRST_SOLUTION    ");
        } else if (policy == ResolutionPolicy.SATISFACTION) {
            b.append("ALL_SOLUTIONS    ");
        }
        b.append(problemName).append("    ");
        b.append(instanceName).append("    ");
        b.append(conf.readString("cp.random.seed")).append(" SEED");
        return b.toString();
    }

    private static String getLimitMsg(Configuration conf, String name, String key, String boundKey) {
        Limit lim = (Limit)((Object)conf.readEnum(key, Limit.class));
        if (!lim.equals((Object)Limit.UNDEF)) {
            return name + ' ' + conf.readString(boundKey) + ' ' + lim.getUnit() + "    ";
        }
        return "";
    }

    public static String getLimitMsg(Solver solver) {
        Configuration conf = solver.getConfiguration();
        return MessageFactory.getLimitMsg(conf, "SEARCH_LIMIT", "cp.search.limit.type", "cp.search.limit.value") + MessageFactory.getLimitMsg(conf, "RESTART_LIMIT", "cp.search.limit.type", "cp.search.limit.value");
    }

    private static String getPolicyMsg(Configuration conf, String name, String growKey) {
        return name + "( " + conf.readString("cp.restart.base") + ", " + conf.readString(growKey) + " )    ";
    }

    public static String getRestartMsg(Solver solver) {
        StringBuilder b = new StringBuilder(128);
        Configuration conf = solver.getConfiguration();
        if (conf.readBoolean("cp.restart.luby")) {
            b.append(MessageFactory.getPolicyMsg(conf, "LUBY", "cp.restart.luby.grow"));
        } else if (conf.readBoolean("cp.restart.geometrical")) {
            b.append(MessageFactory.getPolicyMsg(conf, "GEOM", "cp.restart.geometrical.grow"));
        }
        if (conf.readBoolean("cp.restart.after_solution")) {
            b.append("FROM_SOLUTION    ");
        }
        if (conf.readBoolean("cp.restart.nogood_recording")) {
            b.append("NOGOOD_RECORDING");
        }
        return b.toString();
    }

    public static String getShavingMsg(Solver solver) {
        StringBuilder b = new StringBuilder(128);
        Configuration conf = solver.getConfiguration();
        if (conf.readBoolean("cp.search.bottom_up")) {
            b.append("BOTTOM_UP    ");
        }
        if (conf.readBoolean("cp.init.propagation.shaving")) {
            b.append("SHAVING    ");
        }
        if (conf.readBoolean("cp.init.propagation.shaving")) {
            b.append("DESTRUCTIVE_LOWER_BOUND");
            if (conf.readBoolean("cp.init.propagation.shaving.dLB")) {
                b.append("_WITH_SHAVING");
            }
        }
        return b.toString();
    }

    public static String getModellingMsg(Solver solver) {
        return solver.getNbVars() + " VARIABLES\t" + solver.getNbConstraints() + " CONSTRAINTS";
    }
}

