/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectLongIterator;
import gnu.trove.TObjectLongProcedure;
import gnu.trove.TObjectProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectLongHashMap<K>
extends TObjectHash<K>
implements Externalizable {
    static final long serialVersionUID = 1L;
    private final TObjectLongProcedure<K> PUT_ALL_PROC = new TObjectLongProcedure<K>(){

        @Override
        public boolean execute(K key, long value) {
            TObjectLongHashMap.this.put(key, value);
            return true;
        }
    };
    protected transient long[] _values;

    public TObjectLongHashMap() {
    }

    public TObjectLongHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectLongHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectLongHashMap(TObjectHashingStrategy<K> strategy) {
        super(strategy);
    }

    public TObjectLongHashMap(int initialCapacity, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectLongHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectLongIterator<K> iterator() {
        return new TObjectLongIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new long[capacity];
        return capacity;
    }

    public long put(K key, long value) {
        int index = this.insertionIndex(key);
        return this.doPut(key, value, index);
    }

    public long putIfAbsent(K key, long value) {
        int index = this.insertionIndex(key);
        if (index < 0) {
            return this._values[-index - 1];
        }
        return this.doPut(key, value, index);
    }

    private long doPut(K key, long value, int index) {
        long previous = 0L;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == FREE);
        }
        return previous;
    }

    public void putAll(TObjectLongHashMap<K> map) {
        map.forEachEntry(this.PUT_ALL_PROC);
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        long[] oldVals = this._values;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        this._values = new long[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == FREE || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public long get(K key) {
        int index = this.index(key);
        return index < 0 ? 0L : this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys = this._set;
        long[] vals = this._values;
        Arrays.fill(this._set, 0, this._set.length, FREE);
        Arrays.fill(this._values, 0, this._values.length, 0L);
    }

    public long remove(K key) {
        long prev = 0L;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectLongHashMap)) {
            return false;
        }
        TObjectLongHashMap that = (TObjectLongHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    @Override
    public TObjectLongHashMap<K> clone() {
        TObjectLongHashMap clone = (TObjectLongHashMap)super.clone();
        clone._values = new long[this._values.length];
        System.arraycopy(this._values, 0, clone._values, 0, clone._values.length);
        return clone;
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = 0L;
        super.removeAt(index);
    }

    public long[] getValues() {
        long[] vals = new long[this.size()];
        long[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == FREE || k[i] == REMOVED) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public K[] keys(K[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == FREE || k[i] == REMOVED) continue;
            a[j++] = k[i];
        }
        return a;
    }

    public boolean containsValue(long val) {
        Object[] keys = this._set;
        long[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K key) {
        return this.contains(key);
    }

    public boolean forEachKey(TObjectProcedure<K> procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TLongProcedure procedure) {
        Object[] keys = this._set;
        long[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectLongProcedure<K> procedure) {
        Object[] keys = this._set;
        long[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TObjectLongProcedure<K> procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        long[] values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    public void transformValues(TLongFunction function) {
        Object[] keys = this._set;
        long[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(K key) {
        return this.adjustValue(key, 1L);
    }

    public boolean adjustValue(K key, long amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    public long adjustOrPutValue(K key, long adjust_amount, long put_amount) {
        boolean isNewMapping;
        long newValue;
        int index = this.insertionIndex(key);
        if (index < 0) {
            int n = index = -index - 1;
            long l = this._values[n] + adjust_amount;
            this._values[n] = l;
            newValue = l;
            isNewMapping = false;
        } else {
            newValue = this._values[index] = put_amount;
            isNewMapping = true;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        if (isNewMapping) {
            this.postInsertHook(oldKey == FREE);
        }
        return newValue;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(out);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            Object key = in.readObject();
            long val = in.readLong();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TObjectLongProcedure<K>(){
            private boolean first = true;

            @Override
            public boolean execute(K key, long value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(",");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    private static final class EqProcedure
    implements TObjectLongProcedure {
        private final TObjectLongHashMap _otherMap;

        EqProcedure(TObjectLongHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(Object key, long value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(long v1, long v2) {
            return v1 == v2;
        }
    }
}

