% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompletingMatrices.R
\name{complete_rows_cols}
\alias{complete_rows_cols}
\title{Complete rows and columns in one matrix relative to another}
\usage{
complete_rows_cols(
  a = NULL,
  mat = NULL,
  fill = 0,
  fillrow = NULL,
  fillcol = NULL,
  margin = c(1, 2)
)
}
\arguments{
\item{a}{A matrix or list of matrices to be completed.}

\item{mat}{A matrix from which dimnames will be extracted
for the purposes of completing \code{a} with respect to \code{mat}.}

\item{fill}{Rows and columns added to \code{a} will contain the value \code{fill}.
(Default is \code{0}.)}

\item{fillrow}{A row vector of type \code{matrix} with same column names as \code{a}.
Any rows added to \code{a} will be \code{fillrow}.
If non-\code{NULL}, \code{fillrow} takes precedence over both \code{fillcol} and \code{fill}
in the case of conflicts.}

\item{fillcol}{A column vector of type matrix with same row names as \code{a}.
Any columns added to \code{a} will be \code{fillcol}.
If non-\code{NULL}, \code{fillcol} takes precedence over \code{fill}
in the case of conflicts.}

\item{margin}{Specifies the subscript(s) in \code{a} over which completion will occur
\code{margin} has nearly the same semantic meaning as in \code{base::apply()}
For rows only, give \code{1};
for columns only, give \code{2};
for both rows and columns, give \code{c(1,2)}, the default value.}
}
\value{
A modified version of \code{a} possibly containing additional rows and columns
whose names are obtained from \code{mat}.
}
\description{
"Completing" rows and columns means that \code{a} contains a union of rows and columns
between \code{a} and \code{mat},
with missing data represented by the value for \code{fill} (\code{0}, by default),
\code{fillrow}, or \code{fillcol}.
}
\details{
Note that \code{complete_rows_cols(mat1, mat2)} and \code{complete_rows_cols(mat2, mat1)} are
not guaranteed to have the same order for rows and columns.
(Nor are the values in the matrix guaranteed to have the same positions.)

If \code{dimnames(mat)} is \code{NULL}, \code{a} is returned unmodified.

If either \code{a} or \code{mat} are missing names on a margin (row or column),
an error is given.

When \code{a} is non-\code{NULL},
\code{a} is named, and \code{mat} is \code{NULL} (the default),
\code{a} is completed relative to itself,
meaning that \code{a} will be made square,
containing the union of row and column names from \code{a}.
Under these conditions, no warning is given.

If \code{mat} is non-\code{NULL} and dimnames of \code{mat} cannot be determined
(because, for example, \code{mat} doesn't have dimnames),
\code{a} is completed relative to itself and a warning is given.

All added rows and columns will be created from one of the \verb{fill*} arguments.
When conflicts arise, precedence among the \verb{fill*} arguments is
\code{fillrow} then \code{fillcol} then \code{fill}.
}
\examples{
m1 <- matrix(c(1:6), nrow=3, dimnames = list(c("r1", "r2", "r3"), c("c1", "c2")))
m1
m2 <- matrix(c(7:12), ncol=3, dimnames = list(c("r2", "r3"), c("c2", "c3", "c4")))
m2
complete_rows_cols(m1, m2) # Adds empty column c4
complete_rows_cols(m1, t(m2)) # Creates r2, r3 columns; c2, c3, c4 rows
complete_rows_cols(m1, m2, margin = 1) # No changes because r2 and r3 already present in m1
complete_rows_cols(m1, m2, margin = 2) # Adds empty columns c3 and c4
complete_rows_cols(m1, t(m2), margin = 1) # Adds empty rows c2, c3, c4
complete_rows_cols(m1, m2, fill = 100) # Adds columns c3 and c4 with 100's
complete_rows_cols(m1, m1) # Nothing added, because everything already present
complete_rows_cols(m1, t(m1)) # Adds empty c1, c2 rows; Adds empty r1, r2, r3 columns
# Same as previous. With missing matrix, complete relative to transpose of m1.
complete_rows_cols(m1) 
# Adds rows r10, r11; cols c10, c11
complete_rows_cols(m1, matrix(0, nrow = 2, ncol = 2, 
                              dimnames = list(c("r10", "r11"), c("c10", "c11")))) 
# Also works with lists
complete_rows_cols(a = list(m1,m1))
complete_rows_cols(a = list(m1,m1), mat = list(m2,m2))
# No changes because r2, r3 already present in m1
complete_rows_cols(a = list(m1,m1), mat = list(m2,m2), margin = 1) 
complete_rows_cols(a = list(m1,m1), mat = list(m2,m2), margin = 2)
complete_rows_cols(a = list(m1,m1), 
                   mat = RCLabels::make_list(matrix(0,
                                                    nrow = 2, 
                                                    ncol = 2, 
                                                    dimnames = list(c("r10", "r11"), 
                                                                    c("c10", "c11"))), 
                                             n = 2, lenx = 1))
# fillrow or fillcol can be specified
a <- matrix(c(11, 12, 21, 22), byrow = TRUE, nrow = 2, ncol = 2, 
            dimnames = list(c("r1", "r2"), c("c1", "c2")))
b <- matrix(c(1:6), byrow = TRUE, nrow = 3, ncol = 2, 
            dimnames = list(c("r1", "r2", "r3"), c("c1", "c2")))
fillrow <- matrix(c(31, 32), byrow = TRUE, nrow = 1, ncol = 2, 
                  dimnames = list("r42", c("c1", "c2")))
complete_rows_cols(a = a, mat = b, fillrow = fillrow)
}
