% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.catecls.func.R
\name{generate.catecls}
\alias{generate.catecls}
\title{Generate (NxJ) clustered categorical data matrix.}
\usage{
generate.catecls(
  N = N,
  J = J,
  q.vec = q.vec,
  Ktrue = Ktrue,
  prop.J.list = prop.J.list,
  clstr.vec = clstr.vec
)
}
\arguments{
\item{N}{The number of observations.}

\item{J}{The number of active variables.}

\item{q.vec}{A vector of length J giving the number of categories for each active variable.}

\item{Ktrue}{An integer indicating the number of content-based clusters used for CCRS estimation.}

\item{prop.J.list}{a list of length J, where each list is a (Ktrue x qj) matrix giving the proportion for each qj category in each of the \code{Ktrue} cluster.}

\item{clstr.vec}{A vector of length N giving true clusters for each observations.}
}
\value{
an (NxJ) clustered categorical data matrix.
}
\description{
Generate an (NxJ) clustered categorical data matrix given by prop.J.list and true cluster allocation.
}
