% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Wrapper function that retrieves the DHS data used for modelling the
proportion of modern contraceptives supplied by the public and private
sectors at the national and subnational administration levels.}
\usage{
get_data(
  national = TRUE,
  local = FALSE,
  mycountry = NULL,
  fp2030 = TRUE,
  surveydata_filepath = NULL,
  trunc = FALSE
)
}
\arguments{
\item{national}{TRUE/FALSE. Default is TRUE for national administration level
data. FALSE retrieves subnational level data.}

\item{local}{TRUE/FALSE. Default is FALSE for global runs. Decides if this is
a single-country or global run.}

\item{mycountry}{The name of country of interest. Default is NULL. For the
names of potential countries, review vigentte.}

\item{fp2030}{Default is TRUE. Filter raw data to only include the Family
Planning 2030 focus countries discussed in the Comiskey et al. paper.}

\item{surveydata_filepath}{Path to survey data. Default is NULL. Survey data
should be a .xlsx with the following format
\code{\link{national_FPsource_data}}.}

\item{trunc}{Default is FALSE. This argument indicates to function to use a
small 4 country dataset for illustration purposes.
See ?mcmsupply::trunc_subnat_FPsource_data or
??mcmsupply::trunc_national_FPsource_data for details.}
}
\value{
returns a list containing the DHS data set used for inputs into the
model and the arguments that specify the data set up.
}
\description{
Wrapper function that retrieves the DHS data used for modelling the
proportion of modern contraceptives supplied by the public and private
sectors at the national and subnational administration levels.
}
\examples{
\donttest{
raw_data <- get_data(national=FALSE, local=TRUE, mycountry="Nepal")
}
}
