% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcMMDeming.r
\name{mc.mmdemingConstCV}
\alias{mc.mmdemingConstCV}
\title{Calculate Weighted Deming Regression}
\usage{
mc.mmdemingConstCV(
  X,
  Y,
  error.ratio,
  iter.max = 120,
  threshold = 1e-06,
  tauMM = 4.685
)
}
\arguments{
\item{X}{measurement values of reference method.}

\item{Y}{measurement values of test method.}

\item{error.ratio}{ratio between squared measurement errors of reference- and test method, necessary for Deming regression (Default is 1).}

\item{iter.max}{maximal number of iterations.}

\item{threshold}{threshold value.}

\item{tauMM}{Tukey's tau for bisquare redescending weighting function, default tauMM = 4,685}
}
\value{
a list with elements
 \item{b0}{intercept.}
 \item{b1}{slope.}
 \item{xw}{average of reference method values.}
 \item{iter}{number of iterations.}
}
\description{
Calculate weighted Deming regression with iterative algorithm suggested by Linnet.
This algorithm is available only for positive values. But even in this case there is no guarantee that
the algorithm always converges.
}
\references{
Linnet K.
             Evaluation of Regression Procedures for Methods Comparison Studies.
             CLIN. CHEM. 39/3, 424-432 (1993).

             Linnet K.
             Estimation of the Linear Relationship between the Measurements of two Methods with Proportional Errors.
             STATISTICS IN MEDICINE, Vol. 9, 1463-1473 (1990).
}
