% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{selectCompNum.pls}
\alias{selectCompNum.pls}
\title{Select optimal number of components for PLS model}
\usage{
\method{selectCompNum}{pls}(model, ncomp = NULL,
  selcrit = model$ncomp.selcrit, ...)
}
\arguments{
\item{model}{PLS model (object of class \code{pls})}

\item{ncomp}{number of components to select}

\item{selcrit}{criterion for selecting optimal number of components (\code{'min'} for 
first local minimum of RMSECV and \code{'wold'} for Wold's rule.)}

\item{...}{other parameters if any}
}
\value{
the same model with selected number of components
}
\description{
Allows user to select optimal number of components for PLS model
}
\details{
If number of components is not specified, the cross-validation statistics will be used. It can
be either first local minimum of RMSECV (`selcrit='min'`) or Wold's rule (`selcrit='wold'`)
based on ratio of PRESS values and threshold of 0.95. 

See examples in help for \code{\link{pls}} function.
}
